/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.cloud.consul.config.ConsulConfigProperties;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

public class ConsulPropertySource
extends EnumerablePropertySource<ConsulClient> {
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private String context;
    private ConsulConfigProperties configProperties;
    private Long initialIndex;

    public ConsulPropertySource(String context, ConsulClient source, ConsulConfigProperties configProperties) {
        super(context, (Object)source);
        this.context = context;
        this.configProperties = configProperties;
    }

    public void init() {
        if (!this.context.endsWith("/")) {
            this.context = this.context + "/";
        }
        Response response = ((ConsulClient)this.source).getKVValues(this.context, this.configProperties.getAclToken(), QueryParams.DEFAULT);
        this.initialIndex = response.getConsulIndex();
        List values = (List)response.getValue();
        ConsulConfigProperties.Format format = this.configProperties.getFormat();
        switch (format) {
            case KEY_VALUE: {
                this.parsePropertiesInKeyValueFormat(values);
                break;
            }
            case PROPERTIES: 
            case YAML: {
                this.parsePropertiesWithNonKeyValueFormat(values, format);
            }
        }
    }

    public Long getInitialIndex() {
        return this.initialIndex;
    }

    protected void parsePropertiesInKeyValueFormat(List<GetValue> values) {
        if (values == null) {
            return;
        }
        for (GetValue getValue : values) {
            String key = getValue.getKey();
            if (StringUtils.endsWithIgnoreCase((String)key, (String)"/")) continue;
            key = key.replace(this.context, "").replace('/', '.');
            String value = getValue.getDecodedValue();
            this.properties.put(key, value);
        }
    }

    protected void parsePropertiesWithNonKeyValueFormat(List<GetValue> values, ConsulConfigProperties.Format format) {
        if (values == null) {
            return;
        }
        for (GetValue getValue : values) {
            String key = getValue.getKey().replace(this.context, "");
            if (!this.configProperties.getDataKey().equals(key)) continue;
            this.parseValue(getValue, format);
        }
    }

    protected void parseValue(GetValue getValue, ConsulConfigProperties.Format format) {
        String value = getValue.getDecodedValue();
        if (value == null) {
            return;
        }
        Properties props = this.generateProperties(value, format);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.properties.put(entry.getKey().toString(), entry.getValue());
        }
    }

    protected Properties generateProperties(String value, ConsulConfigProperties.Format format) {
        Properties props = new Properties();
        if (format == ConsulConfigProperties.Format.PROPERTIES) {
            try {
                props.load(new ByteArrayInputStream(value.getBytes("ISO-8859-1")));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(value + " can't be encoded using ISO-8859-1");
            }
            return props;
        }
        if (format == ConsulConfigProperties.Format.YAML) {
            YamlPropertiesFactoryBean yaml = new YamlPropertiesFactoryBean();
            yaml.setResources(new Resource[]{new ByteArrayResource(value.getBytes(Charset.forName("UTF-8")))});
            return yaml.getObject();
        }
        return props;
    }

    @Deprecated
    public String getDecoded(String value) {
        if (value == null) {
            return null;
        }
        return new String(Base64Utils.decodeFromString((String)value));
    }

    protected Map<String, Object> getProperties() {
        return this.properties;
    }

    protected ConsulConfigProperties getConfigProperties() {
        return this.configProperties;
    }

    protected String getContext() {
        return this.context;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public String[] getPropertyNames() {
        Set<String> strings = this.properties.keySet();
        return strings.toArray(new String[strings.size()]);
    }
}

