/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.cloud.consul.config")
public class ConsulConfigProperties {
    private boolean enabled = true;
    @NotEmpty
    private String prefix = "config";
    @NotEmpty
    private String defaultContext = "application";
    @NotEmpty
    private String profileSeparator = ",";
    @NotNull
    private Format format = Format.KEY_VALUE;
    @NotEmpty
    private String dataKey = "data";
    @Value(value="${consul.token:${CONSUL_TOKEN:${spring.cloud.consul.token:${SPRING_CLOUD_CONSUL_TOKEN:}}}}")
    private String aclToken;
    private Watch watch = new Watch();
    private boolean failFast = true;

    @PostConstruct
    public void init() {
        if (this.format == Format.FILES) {
            this.profileSeparator = "-";
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getDefaultContext() {
        return this.defaultContext;
    }

    public String getProfileSeparator() {
        return this.profileSeparator;
    }

    public Format getFormat() {
        return this.format;
    }

    public String getDataKey() {
        return this.dataKey;
    }

    public String getAclToken() {
        return this.aclToken;
    }

    public Watch getWatch() {
        return this.watch;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDefaultContext(String defaultContext) {
        this.defaultContext = defaultContext;
    }

    public void setProfileSeparator(String profileSeparator) {
        this.profileSeparator = profileSeparator;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void setDataKey(String dataKey) {
        this.dataKey = dataKey;
    }

    public void setAclToken(String aclToken) {
        this.aclToken = aclToken;
    }

    public void setWatch(Watch watch) {
        this.watch = watch;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsulConfigProperties)) {
            return false;
        }
        ConsulConfigProperties other = (ConsulConfigProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$defaultContext = this.getDefaultContext();
        String other$defaultContext = other.getDefaultContext();
        if (this$defaultContext == null ? other$defaultContext != null : !this$defaultContext.equals(other$defaultContext)) {
            return false;
        }
        String this$profileSeparator = this.getProfileSeparator();
        String other$profileSeparator = other.getProfileSeparator();
        if (this$profileSeparator == null ? other$profileSeparator != null : !this$profileSeparator.equals(other$profileSeparator)) {
            return false;
        }
        Format this$format = this.getFormat();
        Format other$format = other.getFormat();
        if (this$format == null ? other$format != null : !((Object)((Object)this$format)).equals((Object)other$format)) {
            return false;
        }
        String this$dataKey = this.getDataKey();
        String other$dataKey = other.getDataKey();
        if (this$dataKey == null ? other$dataKey != null : !this$dataKey.equals(other$dataKey)) {
            return false;
        }
        String this$aclToken = this.getAclToken();
        String other$aclToken = other.getAclToken();
        if (this$aclToken == null ? other$aclToken != null : !this$aclToken.equals(other$aclToken)) {
            return false;
        }
        Watch this$watch = this.getWatch();
        Watch other$watch = other.getWatch();
        if (this$watch == null ? other$watch != null : !((Object)this$watch).equals(other$watch)) {
            return false;
        }
        return this.isFailFast() == other.isFailFast();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsulConfigProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $defaultContext = this.getDefaultContext();
        result = result * 59 + ($defaultContext == null ? 43 : $defaultContext.hashCode());
        String $profileSeparator = this.getProfileSeparator();
        result = result * 59 + ($profileSeparator == null ? 43 : $profileSeparator.hashCode());
        Format $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)((Object)$format)).hashCode());
        String $dataKey = this.getDataKey();
        result = result * 59 + ($dataKey == null ? 43 : $dataKey.hashCode());
        String $aclToken = this.getAclToken();
        result = result * 59 + ($aclToken == null ? 43 : $aclToken.hashCode());
        Watch $watch = this.getWatch();
        result = result * 59 + ($watch == null ? 43 : ((Object)$watch).hashCode());
        result = result * 59 + (this.isFailFast() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ConsulConfigProperties(enabled=" + this.isEnabled() + ", prefix=" + this.getPrefix() + ", defaultContext=" + this.getDefaultContext() + ", profileSeparator=" + this.getProfileSeparator() + ", format=" + (Object)((Object)this.getFormat()) + ", dataKey=" + this.getDataKey() + ", aclToken=" + this.getAclToken() + ", watch=" + this.getWatch() + ", failFast=" + this.isFailFast() + ")";
    }

    public static enum Format {
        KEY_VALUE,
        PROPERTIES,
        YAML,
        FILES;

    }

    public class Watch {
        private int waitTime = 55;
        private boolean enabled = true;
        private int delay = 1000;

        public int getWaitTime() {
            return this.waitTime;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getDelay() {
            return this.delay;
        }

        public void setWaitTime(int waitTime) {
            this.waitTime = waitTime;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setDelay(int delay) {
            this.delay = delay;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Watch)) {
                return false;
            }
            Watch other = (Watch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWaitTime() != other.getWaitTime()) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            return this.getDelay() == other.getDelay();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Watch;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWaitTime();
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + this.getDelay();
            return result;
        }

        public String toString() {
            return "ConsulConfigProperties.Watch(waitTime=" + this.getWaitTime() + ", enabled=" + this.isEnabled() + ", delay=" + this.getDelay() + ")";
        }
    }
}

