/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.binder;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.consul.binder.ConsulInboundMessageProducer;
import org.springframework.cloud.consul.binder.ConsulSendingHandler;
import org.springframework.cloud.consul.binder.EventService;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.DefaultBinding;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.context.Lifecycle;
import org.springframework.integration.endpoint.EventDrivenConsumer;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.Assert;

public class ConsulBinder
extends AbstractBinder<MessageChannel, ConsumerProperties, ProducerProperties> {
    private static final String BEAN_NAME_TEMPLATE = "outbound.%s";
    private final EventService eventService;

    public ConsulBinder(EventService eventService) {
        this.eventService = eventService;
    }

    protected Binding<MessageChannel> doBindConsumer(String name, String group, MessageChannel inputChannel, ConsumerProperties properties) {
        ConsulInboundMessageProducer messageProducer = new ConsulInboundMessageProducer(this.eventService);
        messageProducer.setOutputChannel(inputChannel);
        messageProducer.setBeanFactory((BeanFactory)this.getBeanFactory());
        messageProducer.afterPropertiesSet();
        messageProducer.start();
        return new DefaultBinding(name, group, (Object)inputChannel, (Lifecycle)messageProducer);
    }

    protected Binding<MessageChannel> doBindProducer(String name, MessageChannel channel, ProducerProperties properties) {
        Assert.isInstanceOf(SubscribableChannel.class, (Object)channel);
        this.logger.debug((Object)("Binding Consul client to eventName " + name));
        ConsulSendingHandler sendingHandler = new ConsulSendingHandler(this.eventService.getConsulClient(), name);
        EventDrivenConsumer consumer = new EventDrivenConsumer((SubscribableChannel)channel, (MessageHandler)sendingHandler);
        consumer.setBeanFactory((BeanFactory)this.getBeanFactory());
        consumer.setBeanName(String.format(BEAN_NAME_TEMPLATE, name));
        consumer.afterPropertiesSet();
        consumer.start();
        return new DefaultBinding(name, null, (Object)channel, (Lifecycle)consumer);
    }
}

