/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.binder;

import java.util.Arrays;
import org.springframework.cloud.consul.ConsulClient;
import org.springframework.http.ResponseEntity;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;

public class ConsulSendingHandler
extends AbstractMessageHandler {
    private final ConsulClient consul;
    private final String eventName;

    public ConsulSendingHandler(ConsulClient consul, String eventName) {
        this.consul = consul;
        this.eventName = eventName;
    }

    protected void handleMessageInternal(Message<?> message) {
        Object payload;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((CharSequence)("Publishing message" + String.valueOf(message)));
        }
        if ((payload = message.getPayload()) instanceof byte[]) {
            payload = Arrays.toString((byte[])payload);
        }
        ResponseEntity event = this.consul.eventFire(this.eventName, (String)payload);
    }
}

