/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.binder;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.event.EventListRequest;
import com.ecwid.consul.v1.event.model.Event;
import com.ecwid.consul.v1.event.model.EventParams;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.cloud.consul.binder.config.ConsulBinderProperties;

public class EventService {
    protected ConsulBinderProperties properties;
    protected ConsulClient consul;
    protected ObjectMapper objectMapper = new ObjectMapper();
    private AtomicReference<Long> lastIndex = new AtomicReference();

    public EventService(ConsulBinderProperties properties, ConsulClient consul, ObjectMapper objectMapper) {
        this.properties = properties;
        this.consul = consul;
        this.objectMapper = objectMapper;
    }

    public ConsulClient getConsulClient() {
        return this.consul;
    }

    @PostConstruct
    public void init() {
        this.setLastIndex(this.getEventsResponse());
    }

    public Long getLastIndex() {
        return this.lastIndex.get();
    }

    private void setLastIndex(Response<?> response) {
        Long consulIndex = response.getConsulIndex();
        if (consulIndex != null) {
            this.lastIndex.set(response.getConsulIndex());
        }
    }

    public Event fire(String name, String payload) {
        Response response = this.consul.eventFire(name, payload, new EventParams(), QueryParams.DEFAULT);
        return (Event)response.getValue();
    }

    public Response<List<Event>> getEventsResponse() {
        return this.consul.eventList(EventListRequest.newBuilder().setQueryParams(QueryParams.DEFAULT).build());
    }

    public List<Event> getEvents() {
        return (List)this.getEventsResponse().getValue();
    }

    public List<Event> getEvents(Long lastIndex) {
        return this.filterEvents(this.readEvents(this.getEventsResponse()), lastIndex);
    }

    public List<Event> watch() {
        return this.watch(this.lastIndex.get());
    }

    public List<Event> watch(Long lastIndex) {
        long index = -1L;
        if (lastIndex != null) {
            index = lastIndex;
        }
        int eventTimeout = 5;
        if (this.properties != null) {
            eventTimeout = this.properties.getEventTimeout();
        }
        Response watch = this.consul.eventList(EventListRequest.newBuilder().setQueryParams(new QueryParams((long)eventTimeout, index)).build());
        return this.filterEvents(this.readEvents((Response<List<Event>>)watch), lastIndex);
    }

    protected List<Event> readEvents(Response<List<Event>> response) {
        this.setLastIndex(response);
        return (List)response.getValue();
    }

    protected List<Event> filterEvents(List<Event> toFilter, Long lastIndex) {
        List<Event> events = toFilter;
        if (lastIndex != null) {
            for (int i = 0; i < events.size(); ++i) {
                Event event = events.get(i);
                Long eventIndex = event.getWaitIndex();
                if (!lastIndex.equals(eventIndex)) continue;
                events = events.subList(i + 1, events.size());
                break;
            }
        }
        return events;
    }
}

