/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.springframework.cloud.config.server.support.CredentialException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;

public class AwsCodeCommitCredentialProvider
extends CredentialsProvider {
    private static final String SHA_256 = "SHA-256";
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final char[] hexArray = "0123456789abcdef".toCharArray();
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private AwsCredentialsProvider awsCredentialProvider;
    private String username;
    private String password;

    protected static String calculateCodeCommitPassword(URIish uri, String awsSecretKey) {
        String codeCommitPassword;
        String[] split = uri.getHost().split("\\.");
        if (split.length < 4) {
            throw new CredentialException("Cannot detect AWS region from URI", null);
        }
        String region = split[1];
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateStamp = dateFormat.format(now);
        String shortDateStamp = dateStamp.substring(0, 8);
        try {
            StringBuilder stringToSign = new StringBuilder();
            stringToSign.append("AWS4-HMAC-SHA256\n").append(dateStamp).append("\n").append(shortDateStamp).append("/").append(region).append("/codecommit/aws4_request\n").append(AwsCodeCommitCredentialProvider.bytesToHexString(AwsCodeCommitCredentialProvider.canonicalRequestDigest(uri)));
            byte[] signedRequest = AwsCodeCommitCredentialProvider.sign(awsSecretKey, shortDateStamp, region, stringToSign.toString());
            codeCommitPassword = dateStamp + "Z" + AwsCodeCommitCredentialProvider.bytesToHexString(signedRequest);
        }
        catch (Exception e) {
            throw new CredentialException("Error calculating AWS CodeCommit password", e);
        }
        return codeCommitPassword;
    }

    private static byte[] hmacSha256(String data, byte[] key) throws Exception {
        String algorithm = HMAC_SHA256;
        Mac mac = Mac.getInstance(algorithm);
        mac.init(new SecretKeySpec(key, algorithm));
        return mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
    }

    private static byte[] sign(String secret, String shortDateStamp, String region, String toSign) throws Exception {
        byte[] kSecret = ("AWS4" + secret).getBytes(StandardCharsets.UTF_8);
        byte[] kDate = AwsCodeCommitCredentialProvider.hmacSha256(shortDateStamp, kSecret);
        byte[] kRegion = AwsCodeCommitCredentialProvider.hmacSha256(region, kDate);
        byte[] kService = AwsCodeCommitCredentialProvider.hmacSha256("codecommit", kRegion);
        byte[] kSigning = AwsCodeCommitCredentialProvider.hmacSha256("aws4_request", kService);
        return AwsCodeCommitCredentialProvider.hmacSha256(toSign, kSigning);
    }

    private static byte[] canonicalRequestDigest(URIish uri) throws NoSuchAlgorithmException {
        StringBuilder canonicalRequest = new StringBuilder();
        canonicalRequest.append("GIT\n").append(uri.getPath()).append("\n").append("\n").append("host:").append(uri.getHost()).append("\n").append("\n").append("host\n");
        MessageDigest digest = MessageDigest.getInstance(SHA_256);
        return digest.digest(canonicalRequest.toString().getBytes());
    }

    private static String bytesToHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static boolean canHandle(String uri) {
        if (!StringUtils.hasText((String)uri)) {
            return false;
        }
        try {
            String host;
            URL url = new URL(uri);
            URI u = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            if (u.getScheme().equals("https") && (host = u.getHost()).endsWith(".amazonaws.com") && host.startsWith("git-codecommit.")) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean supports(CredentialItem ... items) {
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.Username || i instanceof CredentialItem.Password) continue;
            return false;
        }
        return true;
    }

    private AwsCredentials retrieveAwsCredentials() {
        if (this.awsCredentialProvider == null) {
            if (this.username != null && this.password != null) {
                this.logger.debug((Object)"Creating a static AWSCredentialsProvider");
                this.awsCredentialProvider = new AWSStaticCredentialsProvider((AwsCredentials)AwsBasicCredentials.create((String)this.username, (String)this.password));
            } else {
                this.logger.debug((Object)"Creating a default AWSCredentialsProvider");
                this.awsCredentialProvider = DefaultCredentialsProvider.create();
            }
        }
        return this.awsCredentialProvider.resolveCredentials();
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        String codeCommitPassword;
        String awsAccessKey;
        String awsSecretKey;
        try {
            AwsSessionCredentials sessionCreds;
            AwsCredentials awsCredentials = this.retrieveAwsCredentials();
            StringBuilder awsKey = new StringBuilder();
            awsKey.append(awsCredentials.accessKeyId());
            awsSecretKey = awsCredentials.secretAccessKey();
            if (awsCredentials instanceof AwsSessionCredentials && (sessionCreds = (AwsSessionCredentials)awsCredentials).sessionToken() != null) {
                awsKey.append('%').append(sessionCreds.sessionToken());
            }
            awsAccessKey = awsKey.toString();
        }
        catch (Throwable t) {
            this.logger.warn((Object)"Unable to retrieve AWS Credentials", t);
            return false;
        }
        try {
            codeCommitPassword = AwsCodeCommitCredentialProvider.calculateCodeCommitPassword(uri, awsSecretKey);
        }
        catch (Throwable t) {
            this.logger.warn((Object)"Error calculating the AWS CodeCommit password", t);
            return false;
        }
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.Username) {
                ((CredentialItem.Username)i).setValue(awsAccessKey);
                this.logger.trace((Object)("Returning username " + awsAccessKey));
                continue;
            }
            if (i instanceof CredentialItem.Password) {
                ((CredentialItem.Password)i).setValue(codeCommitPassword.toCharArray());
                this.logger.trace((Object)("Returning password " + codeCommitPassword));
                continue;
            }
            if (i instanceof CredentialItem.StringType && i.getPromptText().equals("Password: ")) {
                ((CredentialItem.StringType)i).setValue(codeCommitPassword);
                this.logger.trace((Object)("Returning password string " + codeCommitPassword));
                continue;
            }
            throw new UnsupportedCredentialItem(uri, i.getClass().getName() + ":" + i.getPromptText());
        }
        return true;
    }

    public void reset(URIish uri) {
    }

    public AwsCredentialsProvider getAwsCredentialProvider() {
        return this.awsCredentialProvider;
    }

    public void setAwsCredentialProvider(AwsCredentialsProvider awsCredentialProvider) {
        this.awsCredentialProvider = awsCredentialProvider;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public class AWSStaticCredentialsProvider
    implements AwsCredentialsProvider {
        private final AwsCredentials credentials;

        public AWSStaticCredentialsProvider(AwsCredentials credentials) {
            Assert.notNull((Object)credentials, (String)"credentials");
            this.credentials = credentials;
        }

        public AwsCredentials resolveCredentials() {
            return this.credentials;
        }
    }
}

