/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.config.server.environment.CompositeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.ObservationEnvironmentRepositoryWrapper;
import org.springframework.cloud.config.server.environment.RepositoryException;
import org.springframework.cloud.config.server.environment.SearchPathLocator;

public class SearchPathCompositeEnvironmentRepository
extends CompositeEnvironmentRepository
implements SearchPathLocator {
    public SearchPathCompositeEnvironmentRepository(List<EnvironmentRepository> environmentRepositories, ObservationRegistry observationRegistry, boolean failOnError) {
        super(environmentRepositories, observationRegistry, failOnError);
    }

    @Override
    public SearchPathLocator.Locations getLocations(String application, String profile, String label) {
        ArrayList<String> locations = new ArrayList<String>();
        for (EnvironmentRepository repo : this.environmentRepositories) {
            try {
                ObservationEnvironmentRepositoryWrapper wrapper;
                EnvironmentRepository environmentRepository;
                if (repo instanceof SearchPathLocator) {
                    SearchPathLocator searchPathLocator = (SearchPathLocator)((Object)repo);
                    this.addForSearchPathLocators(application, profile, label, locations, searchPathLocator);
                    continue;
                }
                if (!(repo instanceof ObservationEnvironmentRepositoryWrapper) || !((environmentRepository = (wrapper = (ObservationEnvironmentRepositoryWrapper)repo).getDelegate()) instanceof SearchPathLocator)) continue;
                SearchPathLocator searchPathLocator = (SearchPathLocator)((Object)environmentRepository);
                this.addForSearchPathLocators(application, profile, label, locations, searchPathLocator);
            }
            catch (RepositoryException ex) {
                if (this.failOnError) {
                    throw ex;
                }
                this.log.info((Object)("Error finding locations for " + String.valueOf(repo)), (Throwable)ex);
            }
        }
        return new SearchPathLocator.Locations(application, profile, label, null, locations.toArray(new String[locations.size()]));
    }

    private void addForSearchPathLocators(String application, String profile, String label, List<String> locations, SearchPathLocator searchPathLocator) {
        locations.addAll(Arrays.asList(searchPathLocator.getLocations(application, profile, label).getLocations()));
    }
}

