/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.util.FileUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.AbstractScmEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.NoSuchLabelException;
import org.springframework.cloud.config.server.environment.NoSuchRepositoryException;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.cloud.config.server.support.GitCredentialsProviderFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class JGitEnvironmentRepository
extends AbstractScmEnvironmentRepository
implements EnvironmentRepository,
SearchPathLocator,
InitializingBean {
    public static final String MESSAGE = "You need to configure a uri for the git repository.";
    private static final String FILE_URI_PREFIX = "file:";
    private static final String LOCAL_BRANCH_REF_PREFIX = "refs/remotes/origin/";
    private int timeout;
    private int refreshRate = 0;
    private long lastRefresh;
    private boolean cloneOnStart;
    private JGitFactory gitFactory;
    private String defaultLabel;
    private GitCredentialsProviderFactory gitCredentialsProviderFactory = new GitCredentialsProviderFactory();
    private TransportConfigCallback transportConfigCallback;
    private boolean forcePull;
    private boolean deleteUntrackedBranches;
    private boolean skipSslValidation;
    private boolean tryMasterBranch;
    private final ObservationRegistry observationRegistry;
    private final Object LOCK = new Object();

    public JGitEnvironmentRepository(ConfigurableEnvironment environment, JGitEnvironmentProperties properties, ObservationRegistry observationRegistry) {
        super(environment, properties, observationRegistry);
        this.cloneOnStart = properties.isCloneOnStart();
        this.defaultLabel = properties.getDefaultLabel();
        this.forcePull = properties.isForcePull();
        this.timeout = properties.getTimeout();
        this.deleteUntrackedBranches = properties.isDeleteUntrackedBranches();
        this.refreshRate = properties.getRefreshRate();
        this.skipSslValidation = properties.isSkipSslValidation();
        this.gitFactory = new JGitFactory(properties.isCloneSubmodules());
        this.tryMasterBranch = properties.isTryMasterBranch();
        this.observationRegistry = observationRegistry;
    }

    public boolean isTryMasterBranch() {
        return this.tryMasterBranch;
    }

    public void setTryMasterBranch(boolean tryMasterBranch) {
        this.tryMasterBranch = tryMasterBranch;
    }

    public boolean isCloneOnStart() {
        return this.cloneOnStart;
    }

    public void setCloneOnStart(boolean cloneOnStart) {
        this.cloneOnStart = cloneOnStart;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }

    public TransportConfigCallback getTransportConfigCallback() {
        return this.transportConfigCallback;
    }

    public void setTransportConfigCallback(TransportConfigCallback transportConfigCallback) {
        this.transportConfigCallback = transportConfigCallback;
    }

    public JGitFactory getGitFactory() {
        return this.gitFactory;
    }

    public void setGitFactory(JGitFactory gitFactory) {
        this.gitFactory = gitFactory;
    }

    public void setGitCredentialsProviderFactory(GitCredentialsProviderFactory gitCredentialsProviderFactory) {
        this.gitCredentialsProviderFactory = gitCredentialsProviderFactory;
    }

    GitCredentialsProviderFactory getGitCredentialsProviderFactory() {
        return this.gitCredentialsProviderFactory;
    }

    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    public boolean isForcePull() {
        return this.forcePull;
    }

    public void setForcePull(boolean forcePull) {
        this.forcePull = forcePull;
    }

    public boolean isDeleteUntrackedBranches() {
        return this.deleteUntrackedBranches;
    }

    public void setDeleteUntrackedBranches(boolean deleteUntrackedBranches) {
        this.deleteUntrackedBranches = deleteUntrackedBranches;
    }

    public boolean isSkipSslValidation() {
        return this.skipSslValidation;
    }

    public void setSkipSslValidation(boolean skipSslValidation) {
        this.skipSslValidation = skipSslValidation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Environment findOne(String application, String profile, String label, boolean includeOrigin) {
        Object object = this.LOCK;
        synchronized (object) {
            return super.findOne(application, profile, label, includeOrigin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SearchPathLocator.Locations getLocations(String application, String profile, String label) {
        String version;
        if (label == null) {
            label = this.defaultLabel;
        }
        try {
            Object object = this.LOCK;
            synchronized (object) {
                version = this.refresh(label);
            }
        }
        catch (Exception e) {
            if (this.defaultLabel.equals(label) && "main".equals(this.defaultLabel) && this.tryMasterBranch) {
                this.logger.info((Object)("Could not refresh default label " + label), (Throwable)e);
                this.logger.info((Object)"Will try to refresh master label instead.");
                version = this.refresh("master");
            }
            throw e;
        }
        return new SearchPathLocator.Locations(application, profile, label, version, this.getSearchLocations(this.getWorkingDirectory(), application, profile, label));
    }

    public synchronized void afterPropertiesSet() throws Exception {
        Assert.state((this.getUri() != null ? 1 : 0) != 0, (String)MESSAGE);
        if (this.cloneOnStart) {
            this.initClonedRepository();
        }
    }

    public String refresh(String label) {
        Git git = null;
        try {
            Object fetchStatus;
            git = this.createGitClient();
            if (this.shouldPull(git)) {
                fetchStatus = this.fetch(git, label);
                if (this.deleteUntrackedBranches && fetchStatus != null) {
                    this.deleteUntrackedLocalBranches(fetchStatus.getTrackingRefUpdates(), git);
                }
            }
            this.checkout(git, label);
            this.tryMerge(git, label);
            fetchStatus = git.getRepository().findRef("HEAD").getObjectId().getName();
            return fetchStatus;
        }
        catch (RefNotFoundException e) {
            throw new NoSuchLabelException("No such label: " + label, (Exception)((Object)e));
        }
        catch (NoRemoteRepositoryException e) {
            throw new NoSuchRepositoryException("No such repository: " + this.getUri(), (Exception)((Object)e));
        }
        catch (GitAPIException e) {
            throw new NoSuchRepositoryException("Cannot clone or checkout repository: " + this.getUri(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load environment", e);
        }
        finally {
            try {
                if (git != null) {
                    git.close();
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)"Could not close git repository", (Throwable)e);
            }
        }
    }

    private void tryMerge(Git git, String label) {
        try {
            if (this.isBranch(git, label)) {
                this.merge(git, label);
                if (!this.isClean(git, label)) {
                    this.logger.warn((Object)("The local repository is dirty or ahead of origin. Resetting it to origin/" + label + "."));
                    this.resetHard(git, label, LOCAL_BRANCH_REF_PREFIX + label);
                }
            }
        }
        catch (GitAPIException e) {
            throw new NoSuchRepositoryException("Cannot clone or checkout repository: " + this.getUri(), (Exception)((Object)e));
        }
    }

    private void initClonedRepository() throws GitAPIException, IOException {
        if (!this.getUri().startsWith(FILE_URI_PREFIX)) {
            String defaultBranchInGit;
            this.deleteBaseDirIfExists();
            Git git = this.cloneToBasedir();
            if (git != null) {
                git.close();
            }
            if (!(null == (git = this.openGitRepository()) || git.getRepository() == null || ObjectUtils.isEmpty((Object)this.getDefaultLabel()) || ObjectUtils.isEmpty((Object)(defaultBranchInGit = git.getRepository().getBranch())) || this.getDefaultLabel().equalsIgnoreCase(defaultBranchInGit))) {
                this.checkoutDefaultBranchWithRetry(git);
            }
            if (git != null) {
                git.close();
            }
        }
    }

    private void checkoutDefaultBranchWithRetry(Git git) throws GitAPIException {
        try {
            this.checkout(git, this.getDefaultLabel());
        }
        catch (Exception e) {
            if ("main".equals(this.getDefaultLabel()) && this.tryMasterBranch) {
                this.logger.info((Object)("Could not checkout default label " + this.getDefaultLabel()), (Throwable)e);
                this.logger.info((Object)"Will try to checkout master label instead.");
                this.checkout(git, "master");
            }
            throw e;
        }
    }

    private Collection<String> deleteUntrackedLocalBranches(Collection<TrackingRefUpdate> trackingRefUpdates, Git git) {
        if (CollectionUtils.isEmpty(trackingRefUpdates)) {
            return Collections.emptyList();
        }
        ArrayList<String> branchesToDelete = new ArrayList<String>();
        for (TrackingRefUpdate trackingRefUpdate : trackingRefUpdates) {
            String localRefName;
            ReceiveCommand receiveCommand = trackingRefUpdate.asReceiveCommand();
            if (receiveCommand.getType() != ReceiveCommand.Type.DELETE || !StringUtils.startsWithIgnoreCase((String)(localRefName = trackingRefUpdate.getLocalName()), (String)LOCAL_BRANCH_REF_PREFIX)) continue;
            String localBranchName = localRefName.substring(LOCAL_BRANCH_REF_PREFIX.length(), localRefName.length());
            branchesToDelete.add(localBranchName);
        }
        if (CollectionUtils.isEmpty(branchesToDelete)) {
            return Collections.emptyList();
        }
        try {
            this.checkoutDefaultBranchWithRetry(git);
            return this.deleteBranches(git, branchesToDelete);
        }
        catch (Exception ex) {
            String message = String.format("Failed to delete %s branches.", branchesToDelete);
            this.warn(message, ex);
            return Collections.emptyList();
        }
    }

    private List<String> deleteBranches(Git git, Collection<String> branchesToDelete) throws GitAPIException {
        DeleteBranchCommand deleteBranchCommand = git.branchDelete().setBranchNames(branchesToDelete.toArray(new String[0])).setForce(true);
        List resultList = deleteBranchCommand.call();
        this.logger.info((Object)String.format("Deleted %s branches from %s branches to delete.", resultList, branchesToDelete));
        return resultList;
    }

    private Ref checkout(Git git, String label) throws GitAPIException {
        CheckoutCommand checkout = git.checkout();
        if (this.shouldTrack(git, label)) {
            this.trackBranch(git, checkout, label);
        } else {
            checkout.setName(label);
        }
        return checkout.call();
    }

    protected boolean shouldPull(Git git) throws GitAPIException {
        boolean shouldPull;
        Status gitStatus;
        if (this.refreshRate < 0 || this.refreshRate > 0 && System.currentTimeMillis() - this.lastRefresh < (long)(this.refreshRate * 1000)) {
            return false;
        }
        try {
            gitStatus = git.status().call();
        }
        catch (JGitInternalException e) {
            this.onPullInvalidIndex(git, e);
            gitStatus = git.status().call();
        }
        boolean isWorkingTreeClean = gitStatus.isClean();
        String originUrl = git.getRepository().getConfig().getString("remote", "origin", "url");
        if (this.forcePull && !isWorkingTreeClean) {
            shouldPull = true;
            this.logDirty(gitStatus);
        } else {
            boolean bl = shouldPull = isWorkingTreeClean && originUrl != null;
        }
        if (!isWorkingTreeClean && !this.forcePull) {
            this.logger.info((Object)("Cannot pull from remote " + originUrl + ", the working tree is not clean."));
        }
        return shouldPull;
    }

    protected void onPullInvalidIndex(Git git, JGitInternalException e) {
        if (!e.getMessage().contains("Short read of block.")) {
            throw e;
        }
        if (!this.forcePull) {
            throw e;
        }
        try {
            new File(this.getWorkingDirectory(), ".git/index").delete();
            git.reset().setMode(ResetCommand.ResetType.HARD).setRef("HEAD").call();
        }
        catch (GitAPIException ex) {
            e.addSuppressed((Throwable)ex);
            throw e;
        }
    }

    private void logDirty(Status status) {
        Set<String> dirties = this.dirties(status.getAdded(), status.getChanged(), status.getRemoved(), status.getMissing(), status.getModified(), status.getConflicting(), status.getUntracked());
        this.logger.warn((Object)String.format("Dirty files found: %s", dirties));
    }

    private Set<String> dirties(Set<String> ... changes) {
        HashSet<String> dirties = new HashSet<String>();
        for (Set<String> files : changes) {
            dirties.addAll(files);
        }
        return dirties;
    }

    private boolean shouldTrack(Git git, String label) throws GitAPIException {
        return this.isBranch(git, label) && !this.isLocalBranch(git, label);
    }

    protected FetchResult fetch(Git git, String label) {
        FetchCommand fetch = git.fetch();
        fetch.setRemote("origin");
        fetch.setTagOpt(TagOpt.FETCH_TAGS);
        fetch.setRemoveDeletedRefs(this.deleteUntrackedBranches);
        if (this.refreshRate > 0) {
            this.setLastRefresh(System.currentTimeMillis());
        }
        this.configureCommand((TransportCommand<?, ?>)fetch);
        try {
            FetchResult result = fetch.call();
            if (result.getTrackingRefUpdates() != null && result.getTrackingRefUpdates().size() > 0) {
                this.logger.info((Object)("Fetched for remote " + label + " and found " + result.getTrackingRefUpdates().size() + " updates"));
            }
            return result;
        }
        catch (Exception ex) {
            String message = "Could not fetch remote for " + label + " remote: " + git.getRepository().getConfig().getString("remote", "origin", "url");
            this.warn(message, ex);
            return null;
        }
    }

    private MergeResult merge(Git git, String label) {
        try {
            MergeCommand merge = git.merge();
            merge.include(git.getRepository().findRef("origin/" + label));
            MergeResult result = merge.call();
            if (!result.getMergeStatus().isSuccessful()) {
                this.logger.warn((Object)("Merged from remote " + label + " with result " + String.valueOf(result.getMergeStatus())));
            }
            return result;
        }
        catch (Exception ex) {
            String message = "Could not merge remote for " + label + " remote: " + git.getRepository().getConfig().getString("remote", "origin", "url");
            this.warn(message, ex);
            return null;
        }
    }

    private Ref resetHard(Git git, String label, String ref) {
        ResetCommand reset = git.reset();
        reset.setRef(ref);
        reset.setMode(ResetCommand.ResetType.HARD);
        try {
            Ref resetRef = reset.call();
            if (resetRef != null) {
                this.logger.info((Object)("Reset label " + label + " to version " + String.valueOf(resetRef.getObjectId())));
            }
            return resetRef;
        }
        catch (Exception ex) {
            String message = "Could not reset to remote for " + label + " (current ref=" + ref + "), remote: " + git.getRepository().getConfig().getString("remote", "origin", "url");
            this.warn(message, ex);
            return null;
        }
    }

    private Git createGitClient() throws IOException, GitAPIException {
        File lock = new File(this.getWorkingDirectory(), ".git/index.lock");
        if (lock.exists()) {
            this.logger.info((Object)("Deleting stale JGit lock file at " + String.valueOf(lock)));
            lock.delete();
        }
        if (new File(this.getWorkingDirectory(), ".git").exists()) {
            return this.openGitRepository();
        }
        return this.copyRepository();
    }

    private synchronized Git copyRepository() throws IOException, GitAPIException {
        this.deleteBaseDirIfExists();
        this.getBasedir().mkdirs();
        Assert.state((boolean)this.getBasedir().exists(), (String)("Could not create basedir: " + String.valueOf(this.getBasedir())));
        if (this.getUri().startsWith(FILE_URI_PREFIX)) {
            return this.copyFromLocalRepository();
        }
        return this.cloneToBasedir();
    }

    private Git openGitRepository() throws IOException {
        Git git = this.gitFactory.getGitByOpen(this.getWorkingDirectory());
        return git;
    }

    private Git copyFromLocalRepository() throws IOException {
        File remote = new UrlResource(StringUtils.cleanPath((String)this.getUri())).getFile();
        Assert.state((boolean)remote.isDirectory(), (String)("No directory at " + this.getUri()));
        File gitDir = new File(remote, ".git");
        Assert.state((boolean)gitDir.exists(), (String)("No .git at " + this.getUri()));
        Assert.state((boolean)gitDir.isDirectory(), (String)("No .git directory at " + this.getUri()));
        Git git = this.gitFactory.getGitByOpen(remote);
        return git;
    }

    private Git cloneToBasedir() throws GitAPIException {
        CloneCommand clone = this.gitFactory.getCloneCommandByCloneRepository().setURI(this.getUri()).setDirectory(this.getBasedir());
        this.configureCommand((TransportCommand<?, ?>)clone);
        try {
            return clone.call();
        }
        catch (GitAPIException e) {
            this.logger.warn((Object)"Error occured cloning to base directory.", (Throwable)e);
            this.deleteBaseDirIfExists();
            throw e;
        }
    }

    private void deleteBaseDirIfExists() {
        if (this.getBasedir().exists()) {
            for (File file : this.getBasedir().listFiles()) {
                try {
                    FileUtils.delete((File)file, (int)1);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to initialize base directory", e);
                }
            }
        }
    }

    private void configureCommand(TransportCommand<?, ?> command) {
        CredentialsProvider credentialsProvider;
        command.setTimeout(this.timeout);
        if (this.transportConfigCallback != null) {
            command.setTransportConfigCallback(this.transportConfigCallback);
        }
        if ((credentialsProvider = this.getCredentialsProvider()) != null) {
            command.setCredentialsProvider(credentialsProvider);
        }
    }

    private CredentialsProvider getCredentialsProvider() {
        return this.gitCredentialsProviderFactory.createFor(this.getUri(), this.getUsername(), this.getPassword(), this.getPassphrase(), this.isSkipSslValidation());
    }

    private boolean isClean(Git git, String label) {
        StatusCommand status = git.status();
        try {
            BranchTrackingStatus trackingStatus = BranchTrackingStatus.of((Repository)git.getRepository(), (String)label);
            boolean isBranchAhead = trackingStatus != null && trackingStatus.getAheadCount() > 0;
            return status.call().isClean() && !isBranchAhead;
        }
        catch (Exception e) {
            String message = "Could not execute status command on local repository. Cause: (" + e.getClass().getSimpleName() + ") " + e.getMessage();
            this.warn(message, e);
            return false;
        }
    }

    private void trackBranch(Git git, CheckoutCommand checkout, String label) {
        checkout.setCreateBranch(true).setName(label).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + label);
    }

    private boolean isBranch(Git git, String label) throws GitAPIException {
        return this.containsBranch(git, label, ListBranchCommand.ListMode.ALL);
    }

    private boolean isLocalBranch(Git git, String label) throws GitAPIException {
        return this.containsBranch(git, label, null);
    }

    private boolean containsBranch(Git git, String label, ListBranchCommand.ListMode listMode) throws GitAPIException {
        ListBranchCommand command = git.branchList();
        if (listMode != null) {
            command.setListMode(listMode);
        }
        List branches = command.call();
        for (Ref ref : branches) {
            if (!ref.getName().equals("refs/heads/" + label) && !ref.getName().equals(LOCAL_BRANCH_REF_PREFIX + label)) continue;
            return true;
        }
        return false;
    }

    protected void warn(String message, Exception ex) {
        this.logger.warn((Object)message);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Stacktrace for: " + message), (Throwable)ex);
        }
    }

    public long getLastRefresh() {
        return this.lastRefresh;
    }

    public void setLastRefresh(long lastRefresh) {
        this.lastRefresh = lastRefresh;
    }

    public static class JGitFactory {
        private final boolean cloneSubmodules;

        public JGitFactory() {
            this(false);
        }

        public JGitFactory(boolean cloneSubmodules) {
            this.cloneSubmodules = cloneSubmodules;
        }

        public Git getGitByOpen(File file) throws IOException {
            Git git = Git.open((File)file);
            return git;
        }

        public CloneCommand getCloneCommandByCloneRepository() {
            CloneCommand command = Git.cloneRepository().setCloneSubmodules(this.cloneSubmodules);
            return command;
        }
    }
}

