/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.List;
import java.util.Properties;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.cloud.config.server.environment.S3ConfigFile;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

class YamlS3ConfigFile
extends S3ConfigFile {
    final YamlProcessor.DocumentMatcher[] documentMatchers;

    YamlS3ConfigFile(String application, String profile, String label, String bucketName, S3Client s3Client) {
        this(application, profile, label, bucketName, s3Client, new YamlProcessor.DocumentMatcher[0]);
    }

    YamlS3ConfigFile(String application, String profile, String label, String bucketName, S3Client s3Client, YamlProcessor.DocumentMatcher ... documentMatchers) {
        super(application, profile, label, bucketName, s3Client);
        this.documentMatchers = documentMatchers;
        this.properties = this.read();
    }

    protected static boolean profileMatchesActivateProperty(String profile, Properties properties) {
        return profile.equals(properties.get("spring.config.activate.on-profile")) || profile.equals(properties.get("spring.config.activate.onProfile"));
    }

    protected static boolean onProfilePropertyExists(Properties properties) {
        return properties.get("spring.config.activate.on-profile") != null || properties.get("spring.config.activate.onProfile") != null;
    }

    @Override
    public Properties read() {
        Properties properties;
        block9: {
            if (this.properties != null) {
                return this.properties;
            }
            YamlPropertiesFactoryBean yaml = new YamlPropertiesFactoryBean();
            ResponseInputStream<GetObjectResponse> in = this.getObject();
            try {
                yaml.setResources(new Resource[]{new InputStreamResource(in)});
                yaml.setDocumentMatchers(this.documentMatchers);
                properties = yaml.getObject();
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn((Object)"Could not read YAML file", (Throwable)e);
                    throw new IllegalStateException("Cannot load environment", e);
                }
            }
            in.close();
        }
        return properties;
    }

    @Override
    protected List<String> getExtensions() {
        return List.of("yml", "yaml");
    }
}

