/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.EnvironmentCleaner;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.NativeEnvironmentProperties;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.cloud.config.server.support.AbstractScmAccessor;
import org.springframework.cloud.config.server.support.AbstractScmAccessorProperties;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public abstract class AbstractScmEnvironmentRepository
extends AbstractScmAccessor
implements EnvironmentRepository,
SearchPathLocator,
Ordered {
    private EnvironmentCleaner cleaner = new EnvironmentCleaner();
    private int order = Integer.MAX_VALUE;
    private final ObservationRegistry observationRegistry;

    public AbstractScmEnvironmentRepository(ConfigurableEnvironment environment, ObservationRegistry observationRegistry) {
        super(environment);
        this.observationRegistry = observationRegistry;
    }

    public AbstractScmEnvironmentRepository(ConfigurableEnvironment environment, AbstractScmAccessorProperties properties, ObservationRegistry observationRegistry) {
        super(environment, properties);
        this.order = properties.getOrder();
        this.observationRegistry = observationRegistry;
    }

    @Override
    public synchronized Environment findOne(String application, String profile, String label) {
        return this.findOne(application, profile, label, false);
    }

    @Override
    public synchronized Environment findOne(String application, String profile, String label, boolean includeOrigin) {
        NativeEnvironmentRepository delegate = new NativeEnvironmentRepository(this.getEnvironment(), new NativeEnvironmentProperties(), this.observationRegistry);
        SearchPathLocator.Locations locations = this.getLocations(application, profile, label);
        delegate.setSearchLocations(locations.getLocations());
        Environment result = delegate.findOne(application, profile, "", includeOrigin);
        result.setVersion(locations.getVersion());
        result.setLabel(label);
        return this.cleaner.clean(result, this.getWorkingDirectory().toURI().toString(), this.getUri());
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

