/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.config.server.environment.CompositeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.RepositoryException;
import org.springframework.cloud.config.server.environment.SearchPathLocator;

public class SearchPathCompositeEnvironmentRepository
extends CompositeEnvironmentRepository
implements SearchPathLocator {
    public SearchPathCompositeEnvironmentRepository(List<EnvironmentRepository> environmentRepositories, boolean failOnError) {
        super(environmentRepositories, failOnError);
    }

    @Override
    public SearchPathLocator.Locations getLocations(String application, String profile, String label) {
        ArrayList<String> locations = new ArrayList<String>();
        for (EnvironmentRepository repo : this.environmentRepositories) {
            try {
                if (!(repo instanceof SearchPathLocator)) continue;
                locations.addAll(Arrays.asList(((SearchPathLocator)((Object)repo)).getLocations(application, profile, label).getLocations()));
            }
            catch (RepositoryException ex) {
                if (this.failOnError) {
                    throw ex;
                }
                this.log.info((Object)("Error finding locations for " + repo), (Throwable)ex);
            }
        }
        return new SearchPathLocator.Locations(application, profile, label, null, locations.toArray(new String[locations.size()]));
    }
}

