/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import java.util.Map;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class EnvironmentPropertySource
extends PropertySource<Environment> {
    public static StandardEnvironment prepareEnvironment(Environment environment) {
        StandardEnvironment standardEnvironment = new StandardEnvironment();
        standardEnvironment.getPropertySources().addAfter("systemProperties", (PropertySource)new EnvironmentPropertySource(environment));
        return standardEnvironment;
    }

    public static String resolvePlaceholders(StandardEnvironment preparedEnvironment, String text) {
        text = text.replace("\\${", "$_{");
        return preparedEnvironment.resolvePlaceholders(text).replace("$_{", "${");
    }

    public EnvironmentPropertySource(Environment sources) {
        super("cloudEnvironment", (Object)sources);
    }

    public Object getProperty(String name) {
        for (org.springframework.cloud.config.environment.PropertySource source : ((Environment)this.getSource()).getPropertySources()) {
            Map map = source.getSource();
            if (!map.containsKey(name)) continue;
            return map.get(name);
        }
        return null;
    }
}

