/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.monitor;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bus.event.RefreshRemoteApplicationEvent;
import org.springframework.cloud.config.monitor.PropertyPathNotification;
import org.springframework.cloud.config.monitor.PropertyPathNotificationExtractor;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"${spring.cloud.config.monitor.endpoint.path:}/monitor"})
public class PropertyPathEndpoint
implements ApplicationEventPublisherAware {
    private static Log log = LogFactory.getLog(PropertyPathEndpoint.class);
    private final PropertyPathNotificationExtractor extractor;
    private ApplicationEventPublisher applicationEventPublisher;
    private String busId;

    public PropertyPathEndpoint(PropertyPathNotificationExtractor extractor, String busId) {
        this.extractor = extractor;
        this.busId = busId;
    }

    String getBusId() {
        return this.busId;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @PostMapping
    public Set<String> notifyByPath(@RequestHeader HttpHeaders headers, @RequestBody Map<String, Object> request) {
        PropertyPathNotification notification = this.extractor.extract(headers, request);
        if (notification != null) {
            LinkedHashSet<String> services = new LinkedHashSet<String>();
            for (String path : notification.getPaths()) {
                services.addAll(this.guessServiceName(path));
            }
            if (this.applicationEventPublisher != null) {
                for (String service : services) {
                    log.info((Object)("Refresh for: " + service));
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new RefreshRemoteApplicationEvent((Object)this, this.busId, service));
                }
                return services;
            }
        }
        return Collections.emptySet();
    }

    @PostMapping(consumes={"application/x-www-form-urlencoded"})
    public Set<String> notifyByForm(@RequestHeader HttpHeaders headers, @RequestParam(value="path") List<String> request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String key = "path";
        map.put(key, request);
        return this.notifyByPath(headers, map);
    }

    private Set<String> guessServiceName(String path) {
        LinkedHashSet<String> services = new LinkedHashSet<String>();
        if (path != null) {
            int index;
            String stem = StringUtils.stripFilenameExtension((String)StringUtils.getFilename((String)StringUtils.cleanPath((String)path)));
            Object name = stem + "-";
            while ((index = ((String)name).lastIndexOf("-")) >= 0) {
                if ("application".equals(name = ((String)name).substring(0, index))) {
                    services.add("*");
                    continue;
                }
                services.add((String)name);
            }
        }
        return services;
    }
}

