/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.monitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.config.monitor.PropertyPathNotification;
import org.springframework.cloud.config.monitor.PropertyPathNotificationExtractor;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;

public class CompositePropertyPathNotificationExtractor
implements PropertyPathNotificationExtractor {
    private List<PropertyPathNotificationExtractor> extractors = new ArrayList<PropertyPathNotificationExtractor>();

    public CompositePropertyPathNotificationExtractor(List<PropertyPathNotificationExtractor> extractors) {
        if (extractors != null) {
            this.extractors.addAll(extractors);
        }
        this.extractors.add(new SimplePropertyPathNotificationExtractor());
        AnnotationAwareOrderComparator.sort(this.extractors);
    }

    @Override
    public PropertyPathNotification extract(HttpHeaders headers, Map<String, Object> request) {
        for (PropertyPathNotificationExtractor extractor : this.extractors) {
            PropertyPathNotification result = extractor.extract(headers, request);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Order(value=0x7FFFFF37)
    private static final class SimplePropertyPathNotificationExtractor
    implements PropertyPathNotificationExtractor {
        private SimplePropertyPathNotificationExtractor() {
        }

        @Override
        public PropertyPathNotification extract(HttpHeaders headers, Map<String, Object> request) {
            Object object = request.get("path");
            if (object instanceof String) {
                return new PropertyPathNotification((String)object);
            }
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                return new PropertyPathNotification(collection.toArray(new String[0]));
            }
            return null;
        }
    }
}

