/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.monitor;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.cloud.config.monitor.BitbucketPropertyPathNotificationExtractor;
import org.springframework.cloud.config.monitor.CompositePropertyPathNotificationExtractor;
import org.springframework.cloud.config.monitor.FileMonitorConfiguration;
import org.springframework.cloud.config.monitor.GiteaPropertyPathNotificationExtractor;
import org.springframework.cloud.config.monitor.GiteePropertyPathNotificationExtractor;
import org.springframework.cloud.config.monitor.GithubPropertyPathNotificationExtractor;
import org.springframework.cloud.config.monitor.GitlabPropertyPathNotificationExtractor;
import org.springframework.cloud.config.monitor.GogsPropertyPathNotificationExtractor;
import org.springframework.cloud.config.monitor.PropertyPathEndpoint;
import org.springframework.cloud.config.monitor.PropertyPathNotificationExtractor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication
@Import(value={FileMonitorConfiguration.class})
public class EnvironmentMonitorAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    protected static class PropertyPathNotificationExtractorConfiguration {
        protected PropertyPathNotificationExtractorConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.config.server.monitor.github.enabled"}, havingValue="true", matchIfMissing=true)
        public GithubPropertyPathNotificationExtractor githubPropertyPathNotificationExtractor() {
            return new GithubPropertyPathNotificationExtractor();
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.config.server.monitor.gitlab.enabled"}, havingValue="true", matchIfMissing=true)
        public GitlabPropertyPathNotificationExtractor gitlabPropertyPathNotificationExtractor() {
            return new GitlabPropertyPathNotificationExtractor();
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.config.server.monitor.bitbucket.enabled"}, havingValue="true", matchIfMissing=true)
        public BitbucketPropertyPathNotificationExtractor bitbucketPropertyPathNotificationExtractor() {
            return new BitbucketPropertyPathNotificationExtractor();
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.config.server.monitor.gitea.enabled"}, havingValue="true", matchIfMissing=true)
        public GiteaPropertyPathNotificationExtractor giteaPropertyPathNotificationExtractor() {
            return new GiteaPropertyPathNotificationExtractor();
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.config.server.monitor.gitee.enabled"}, havingValue="true", matchIfMissing=true)
        public GiteePropertyPathNotificationExtractor giteePropertyPathNotificationExtractor() {
            return new GiteePropertyPathNotificationExtractor();
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.config.server.monitor.gogs.enabled"}, havingValue="true", matchIfMissing=true)
        public GogsPropertyPathNotificationExtractor gogsPropertyPathNotificationExtractor() {
            return new GogsPropertyPathNotificationExtractor();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"org.springframework.cloud.bus.BusProperties"})
    protected static class NoBusPropertyPathConfiguration {
        protected NoBusPropertyPathConfiguration() {
        }

        @Bean
        public PropertyPathEndpoint noBusPropertyPathEndpoint(@Value(value="${spring.cloud.bus.id:application}") String id, @Autowired(required=false) List<PropertyPathNotificationExtractor> extractors) {
            return new PropertyPathEndpoint(new CompositePropertyPathNotificationExtractor(extractors), id);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={BusProperties.class})
    protected static class BusPropertyPathConfiguration {
        @Autowired(required=false)
        private List<PropertyPathNotificationExtractor> extractors;

        protected BusPropertyPathConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={BusProperties.class})
        public PropertyPathEndpoint propertyPathEndpoint(BusProperties busProperties) {
            return new PropertyPathEndpoint(new CompositePropertyPathNotificationExtractor(this.extractors), busProperties.getId());
        }

        @Bean
        @ConditionalOnMissingBean(value={BusProperties.class})
        public PropertyPathEndpoint noBusBeanPropertyPathEndpoint(@Value(value="${spring.cloud.bus.id:application}") String id) {
            return new PropertyPathEndpoint(new CompositePropertyPathNotificationExtractor(this.extractors), id);
        }
    }
}

