/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.health.contributor.HealthIndicator;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryHealthIndicatorEnabled;
import org.springframework.cloud.client.actuator.FeaturesEndpoint;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.httpservice.CircuitBreakerRestClientHttpServiceGroupConfigurer;
import org.springframework.cloud.client.circuitbreaker.httpservice.CircuitBreakerWebClientHttpServiceGroupConfigurer;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicator;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.client.discovery.health.DiscoveryCompositeHealthContributor;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.support.RestClientHttpServiceGroupConfigurer;
import org.springframework.web.reactive.function.client.support.WebClientHttpServiceGroupConfigurer;

@Configuration(proxyBeanMethods=false)
public class CommonsClientAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Endpoint.class})
    @ConditionalOnProperty(value={"spring.cloud.features.enabled"}, matchIfMissing=true)
    protected static class ActuatorConfiguration {
        @Autowired(required=false)
        private List<HasFeatures> hasFeatures = new ArrayList<HasFeatures>();

        protected ActuatorConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        public FeaturesEndpoint featuresEndpoint() {
            return new FeaturesEndpoint(this.hasFeatures);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HealthIndicator.class})
    @EnableConfigurationProperties(value={DiscoveryClientHealthIndicatorProperties.class})
    @ConditionalOnBean(value={DiscoveryClient.class})
    @ConditionalOnDiscoveryEnabled
    @ConditionalOnBlockingDiscoveryEnabled
    protected static class DiscoveryLoadBalancerConfiguration {
        protected DiscoveryLoadBalancerConfiguration() {
        }

        @Bean
        @ConditionalOnDiscoveryHealthIndicatorEnabled
        public DiscoveryClientHealthIndicator discoveryClientHealthIndicator(ObjectProvider<DiscoveryClient> discoveryClient, DiscoveryClientHealthIndicatorProperties properties) {
            return new DiscoveryClientHealthIndicator(discoveryClient, properties);
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.discovery.client.composite-indicator.enabled"}, matchIfMissing=true)
        @ConditionalOnBean(value={DiscoveryHealthIndicator.class})
        public DiscoveryCompositeHealthContributor discoveryCompositeHealthContributor(List<DiscoveryHealthIndicator> indicators) {
            return new DiscoveryCompositeHealthContributor(indicators);
        }

        @Bean
        public HasFeatures springCloudCommonsFeatures() {
            return HasFeatures.abstractFeatures(DiscoveryClient.class, LoadBalancerClient.class);
        }
    }

    @ConditionalOnClass(value={CircuitBreaker.class, ReactiveCircuitBreaker.class, WebClientHttpServiceGroupConfigurer.class})
    @ConditionalOnBean(value={CircuitBreakerFactory.class, ReactiveCircuitBreakerFactory.class})
    @ConditionalOnProperty(value={"spring.cloud.circuitbreaker.reactive-http-services.enabled"}, havingValue="true", matchIfMissing=true)
    @Configuration(proxyBeanMethods=false)
    protected static class ReactiveCircuitBreakerInterfaceClientsAutoConfiguration {
        protected ReactiveCircuitBreakerInterfaceClientsAutoConfiguration() {
        }

        @Bean
        public CircuitBreakerWebClientHttpServiceGroupConfigurer circuitBreakerWebClientConfigurer(ReactiveCircuitBreakerFactory<?, ?> reactiveCircuitBreakerFactory, CircuitBreakerFactory<?, ?> circuitBreakerFactory) {
            return new CircuitBreakerWebClientHttpServiceGroupConfigurer(reactiveCircuitBreakerFactory, circuitBreakerFactory);
        }
    }

    @ConditionalOnClass(value={CircuitBreaker.class, RestClientHttpServiceGroupConfigurer.class})
    @ConditionalOnBean(value={CircuitBreakerFactory.class})
    @ConditionalOnProperty(value={"spring.cloud.circuitbreaker.http-services.enabled"}, havingValue="true", matchIfMissing=true)
    @Configuration(proxyBeanMethods=false)
    protected static class CircuitBreakerInterfaceClientsAutoConfiguration {
        protected CircuitBreakerInterfaceClientsAutoConfiguration() {
        }

        @Bean
        public CircuitBreakerRestClientHttpServiceGroupConfigurer circuitBreakerRestClientConfigurer(CircuitBreakerFactory<?, ?> circuitBreakerFactory) {
            return new CircuitBreakerRestClientHttpServiceGroupConfigurer(circuitBreakerFactory);
        }
    }
}

