/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons;

import java.util.Arrays;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public abstract class ConfigDataMissingEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final String CONFIG_IMPORT_PROPERTY = "spring.config.import";
    private static final Bindable<String[]> CONFIG_DATA_LOCATION_ARRAY = Bindable.of(String[].class);
    public static final int ORDER = -2147482638;

    public int getOrder() {
        return -2147482638;
    }

    protected abstract boolean shouldProcessEnvironment(Environment var1);

    protected abstract String getPrefix();

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!this.shouldProcessEnvironment((Environment)environment)) {
            return;
        }
        List<String> property = this.getConfigImports(environment);
        if (property == null || property.isEmpty()) {
            throw new ImportException("No spring.config.import set", false);
        }
        if (!property.stream().anyMatch(impt -> impt.contains(this.getPrefix()))) {
            throw new ImportException("spring.config.import missing " + this.getPrefix(), true);
        }
    }

    private List<String> getConfigImports(ConfigurableEnvironment environment) {
        List<Object> property = (List<Object>)environment.getProperty(CONFIG_IMPORT_PROPERTY, List.class);
        if (property == null || property.isEmpty()) {
            Binder binder = Binder.get((Environment)environment);
            property = Arrays.asList((Object[])binder.bind(CONFIG_IMPORT_PROPERTY, CONFIG_DATA_LOCATION_ARRAY).orElse((Object)new String[0]));
        }
        return property;
    }

    public static class ImportException
    extends RuntimeException {
        public final boolean missingPrefix;

        ImportException(String message, boolean missingPrefix) {
            super(message);
            this.missingPrefix = missingPrefix;
        }
    }
}

