/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.net.URI;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.ClientRequestContext;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.DefaultRequest;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycle;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycleValidator;
import org.springframework.cloud.client.loadbalancer.LoadBalancerUriTools;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.client.loadbalancer.reactive.ExchangeFilterFunctionUtils;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancedExchangeFilterFunction;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class ReactorLoadBalancerExchangeFilterFunction
implements LoadBalancedExchangeFilterFunction {
    private static final Log LOG = LogFactory.getLog(ReactorLoadBalancerExchangeFilterFunction.class);
    private final ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory;
    private final LoadBalancerProperties properties;

    public ReactorLoadBalancerExchangeFilterFunction(ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory, LoadBalancerProperties properties) {
        this.loadBalancerFactory = loadBalancerFactory;
        this.properties = properties;
    }

    public Mono<ClientResponse> filter(ClientRequest clientRequest, ExchangeFunction next) {
        URI originalUrl = clientRequest.url();
        String serviceId = originalUrl.getHost();
        if (serviceId == null) {
            String message = String.format("Request URI does not contain a valid hostname: %s", originalUrl.toString());
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)message);
            }
            return Mono.just((Object)ClientResponse.create((HttpStatus)HttpStatus.BAD_REQUEST).body(message).build());
        }
        Set<LoadBalancerLifecycle> supportedLifecycleProcessors = LoadBalancerLifecycleValidator.getSupportedLifecycleProcessors(this.loadBalancerFactory.getInstances(serviceId, LoadBalancerLifecycle.class), ClientRequestContext.class, ClientResponse.class, ServiceInstance.class);
        String hint = ExchangeFilterFunctionUtils.getHint(serviceId, this.properties.getHint());
        DefaultRequest<ClientRequestContext> lbRequest = new DefaultRequest<ClientRequestContext>(new ClientRequestContext(clientRequest, hint));
        supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onStart(lbRequest));
        return this.choose(serviceId, lbRequest).flatMap(lbResponse -> {
            ServiceInstance instance = (ServiceInstance)lbResponse.getServer();
            if (instance == null) {
                String message = ExchangeFilterFunctionUtils.serviceInstanceUnavailableMessage(serviceId);
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)message);
                }
                supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.DISCARD, lbResponse)));
                return Mono.just((Object)ClientResponse.create((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE).body(ExchangeFilterFunctionUtils.serviceInstanceUnavailableMessage(serviceId)).build());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("LoadBalancer has retrieved the instance for service %s: %s", serviceId, instance.getUri()));
            }
            ClientRequest newRequest = ExchangeFilterFunctionUtils.buildClientRequest(clientRequest, LoadBalancerUriTools.reconstructURI(instance, originalUrl));
            return next.exchange(newRequest).doOnError(throwable -> supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.FAILED, (Throwable)throwable, lbResponse)))).doOnSuccess(clientResponse -> supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.SUCCESS, lbResponse, (ClientResponse)clientResponse))));
        });
    }

    protected Mono<Response<ServiceInstance>> choose(String serviceId, Request<ClientRequestContext> request) {
        ReactiveLoadBalancer<ServiceInstance> loadBalancer = this.loadBalancerFactory.getInstance(serviceId);
        if (loadBalancer == null) {
            return Mono.just((Object)new EmptyResponse());
        }
        return Mono.from(loadBalancer.choose(request));
    }
}

