/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerUriTools;
import org.springframework.cloud.client.loadbalancer.reactive.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.client.loadbalancer.reactive.Response;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class ReactorLoadBalancerExchangeFilterFunction
implements ExchangeFilterFunction {
    private static final Log LOG = LogFactory.getLog(ReactorLoadBalancerExchangeFilterFunction.class);
    private final ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory;

    public ReactorLoadBalancerExchangeFilterFunction(ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory) {
        this.loadBalancerFactory = loadBalancerFactory;
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        URI originalUrl = request.url();
        String serviceId = originalUrl.getHost();
        if (serviceId == null) {
            String message = String.format("Request URI does not contain a valid hostname: %s", originalUrl.toString());
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)message);
            }
            return Mono.just((Object)ClientResponse.create((HttpStatus)HttpStatus.BAD_REQUEST).body(message).build());
        }
        return this.choose(serviceId).flatMap(response -> {
            ServiceInstance instance = (ServiceInstance)response.getServer();
            if (instance == null) {
                String message = this.serviceInstanceUnavailableMessage(serviceId);
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)message);
                }
                return Mono.just((Object)ClientResponse.create((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE).body(this.serviceInstanceUnavailableMessage(serviceId)).build());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Load balancer has retrieved the instance for service %s: %s", serviceId, instance.getUri()));
            }
            ClientRequest newRequest = this.buildClientRequest(request, LoadBalancerUriTools.reconstructURI(instance, originalUrl));
            return next.exchange(newRequest);
        });
    }

    protected Mono<Response<ServiceInstance>> choose(String serviceId) {
        ReactiveLoadBalancer<ServiceInstance> loadBalancer = this.loadBalancerFactory.getInstance(serviceId);
        if (loadBalancer == null) {
            return Mono.just((Object)new EmptyResponse());
        }
        return Mono.from(loadBalancer.choose());
    }

    private String serviceInstanceUnavailableMessage(String serviceId) {
        return "Load balancer does not contain an instance for the service " + serviceId;
    }

    private ClientRequest buildClientRequest(ClientRequest request, URI uri) {
        return ClientRequest.create((HttpMethod)request.method(), (URI)uri).headers(headers -> headers.addAll((MultiValueMap)request.headers())).cookies(cookies -> cookies.addAll(request.cookies())).attributes(attributes -> attributes.putAll(request.attributes())).body(request.body()).build();
    }
}

