/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.health;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;

public class DiscoveryCompositeHealthIndicator
extends CompositeHealthIndicator {
    private final ArrayList<Holder> healthIndicators = new ArrayList();

    @Autowired
    public DiscoveryCompositeHealthIndicator(HealthAggregator healthAggregator, List<DiscoveryHealthIndicator> indicators) {
        super(healthAggregator, DiscoveryCompositeHealthIndicator.createMap(indicators));
        this.getRegistry().getAll().values().stream().filter(healthIndicator -> healthIndicator instanceof Holder).forEach(healthIndicator -> this.healthIndicators.add((Holder)healthIndicator));
    }

    public ArrayList<Holder> getHealthIndicators() {
        return this.healthIndicators;
    }

    public static Map<String, HealthIndicator> createMap(List<DiscoveryHealthIndicator> indicators) {
        HashMap<String, HealthIndicator> map = new HashMap<String, HealthIndicator>();
        for (DiscoveryHealthIndicator indicator : indicators) {
            Holder holder = new Holder(indicator);
            map.put(indicator.getName(), holder);
        }
        return map;
    }

    public static class Holder
    implements HealthIndicator {
        private DiscoveryHealthIndicator delegate;

        public Holder(DiscoveryHealthIndicator delegate) {
            this.delegate = delegate;
        }

        public Health health() {
            return this.delegate.health();
        }

        public DiscoveryHealthIndicator getDelegate() {
            return this.delegate;
        }
    }
}

