/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.cloud.client.discovery.DiscoveryHealthIndicator;

public class DiscoveryCompositeHealthIndicator
extends CompositeHealthIndicator {
    @Autowired
    public DiscoveryCompositeHealthIndicator(HealthAggregator healthAggregator, List<DiscoveryHealthIndicator> indicators) {
        super(healthAggregator);
        for (DiscoveryHealthIndicator indicator : indicators) {
            this.addHealthIndicator(indicator.getName(), new Holder(indicator));
        }
    }

    public static class Holder
    implements HealthIndicator {
        DiscoveryHealthIndicator delegate;

        public Holder(DiscoveryHealthIndicator delegate) {
            this.delegate = delegate;
        }

        public Health health() {
            return this.delegate.health();
        }
    }
}

