/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.DiscoveryHealthIndicator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;

public class DiscoveryClientHealthIndicator
implements ApplicationContextAware,
DiscoveryHealthIndicator,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(DiscoveryClientHealthIndicator.class);
    private ApplicationContext context;
    private int order = Integer.MIN_VALUE;

    @Override
    public Health health() {
        Health.Builder builder = new Health.Builder();
        try {
            DiscoveryClient client = (DiscoveryClient)this.context.getBean(DiscoveryClient.class);
            if (client == null) {
                builder.unknown().withDetail("warning", (Object)"No DiscoveryClient found");
                return builder.build();
            }
            List<String> services = client.getServices();
            builder.status(new Status("UP", client.description())).withDetail("services", services);
        }
        catch (Exception e) {
            log.error("Error", (Throwable)e);
            builder.down(e);
        }
        return builder.build();
    }

    @Override
    public String getName() {
        return "discoveryClient";
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

