/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

public abstract class SingleImplementationImportSelector<T>
implements DeferredImportSelector,
BeanClassLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(SingleImplementationImportSelector.class);
    protected ClassLoader beanClassLoader;
    protected Class<T> annotationClass = GenericTypeResolver.resolveTypeArgument(this.getClass(), SingleImplementationImportSelector.class);

    protected SingleImplementationImportSelector() {
    }

    public String[] selectImports(AnnotationMetadata metadata) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(this.annotationClass.getName(), true));
        Assert.notNull((Object)attributes, (String)("No " + this.getSimpleName() + " attributes found. Is " + metadata.getClassName() + " annotated with @" + this.getSimpleName() + "?"));
        List<Object> factories = new ArrayList(new LinkedHashSet(SpringFactoriesLoader.loadFactoryNames(this.annotationClass, (ClassLoader)this.beanClassLoader)));
        if (factories.size() > 1) {
            String factory = (String)factories.get(0);
            log.warn("More than one implementation of @{}.  Using {} out of available {}", new Object[]{this.getSimpleName(), factory, factories});
            factories = Collections.singletonList(factory);
        }
        return factories.toArray(new String[factories.size()]);
    }

    protected String getSimpleName() {
        return this.annotationClass.getSimpleName();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }
}

