/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class MappingJwtGrantedAuthoritiesConverter
implements Converter<Jwt, Collection<GrantedAuthority>> {
    private static final String DEFAULT_AUTHORITY_PREFIX = "SCOPE_";
    private static final Collection<String> WELL_KNOWN_AUTHORITIES_CLAIM_NAMES = Arrays.asList("scope", "scp");
    private String authorityPrefix = "SCOPE_";
    private String authoritiesClaimName;
    private Map<String, String> authoritiesMapping = new HashMap<String, String>();

    public Collection<GrantedAuthority> convert(Jwt jwt) {
        return this.getAuthorities(jwt).stream().flatMap(authority -> {
            if (this.authoritiesMapping.isEmpty()) {
                return Stream.of(authority);
            }
            return this.authoritiesMapping.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(authority)).map(entry -> (String)entry.getKey()).distinct();
        }).distinct().map(authority -> new SimpleGrantedAuthority(this.authorityPrefix + authority)).collect(Collectors.toSet());
    }

    public void setAuthorityPrefix(String authorityPrefix) {
        Assert.notNull((Object)authorityPrefix, (String)"authorityPrefix cannot be null");
        this.authorityPrefix = authorityPrefix;
    }

    public void setAuthoritiesClaimName(String authoritiesClaimName) {
        Assert.hasText((String)authoritiesClaimName, (String)"authoritiesClaimName cannot be empty");
        this.authoritiesClaimName = authoritiesClaimName;
    }

    public void setAuthoritiesMapping(Map<String, String> authoritiesMapping) {
        Assert.notNull(authoritiesMapping, (String)"authoritiesMapping cannot be null");
        this.authoritiesMapping = authoritiesMapping;
    }

    private String getAuthoritiesClaimName(Jwt jwt) {
        if (this.authoritiesClaimName != null) {
            return this.authoritiesClaimName;
        }
        for (String claimName : WELL_KNOWN_AUTHORITIES_CLAIM_NAMES) {
            if (!jwt.containsClaim(claimName).booleanValue()) continue;
            return claimName;
        }
        return null;
    }

    private Collection<String> getAuthorities(Jwt jwt) {
        String claimName = this.getAuthoritiesClaimName(jwt);
        if (claimName == null) {
            return Collections.emptyList();
        }
        Object authorities = jwt.getClaim(claimName);
        if (authorities instanceof String) {
            if (StringUtils.hasText((String)((String)authorities))) {
                return Arrays.asList(((String)authorities).split(" "));
            }
            return Collections.emptyList();
        }
        if (authorities instanceof Collection) {
            return (Collection)authorities;
        }
        return Collections.emptyList();
    }
}

