/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security;

import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.cloud.common.security.AuthorizationProperties;
import org.springframework.cloud.common.security.support.OnSecurityEnabledAndOAuth2Disabled;
import org.springframework.cloud.common.security.support.SecurityConfigUtils;
import org.springframework.cloud.common.security.support.SecurityStateBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.HttpStatusReturningLogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.session.ExpiringSession;
import org.springframework.session.MapSessionRepository;
import org.springframework.session.SessionRepository;
import org.springframework.session.web.http.HeaderHttpSessionStrategy;
import org.springframework.session.web.http.HttpSessionStrategy;
import org.springframework.session.web.http.SessionRepositoryFilter;
import org.springframework.web.accept.ContentNegotiationStrategy;

@Configuration
@Conditional(value={OnSecurityEnabledAndOAuth2Disabled.class})
@EnableWebSecurity
public class BasicAuthSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    private ContentNegotiationStrategy contentNegotiationStrategy;
    @Autowired
    private SecurityProperties securityProperties;
    @Autowired
    private AuthorizationProperties authorizationProperties;
    @Autowired
    private SecurityStateBean securityStateBean;

    @Bean
    public SessionRepository<ExpiringSession> sessionRepository() {
        return new MapSessionRepository();
    }

    protected void configure(HttpSecurity http) throws Exception {
        MediaTypeRequestMatcher textHtmlMatcher = new MediaTypeRequestMatcher(this.contentNegotiationStrategy, new MediaType[]{MediaType.TEXT_HTML});
        BasicAuthenticationEntryPoint basicAuthenticationEntryPoint = new BasicAuthenticationEntryPoint();
        basicAuthenticationEntryPoint.setRealmName(this.securityProperties.getBasic().getRealm());
        basicAuthenticationEntryPoint.afterPropertiesSet();
        this.authorizationProperties.getAuthenticatedPaths().add("/");
        this.authorizationProperties.getPermitAllPaths().add(this.authorizationProperties.getDashboardUrl());
        this.authorizationProperties.getPermitAllPaths().add(this.dashboard("/**"));
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry security = ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(this.authorizationProperties.getAuthenticatedPaths().toArray(new String[0]))).authenticated().antMatchers(this.authorizationProperties.getPermitAllPaths().toArray(new String[0]))).permitAll();
        if (this.authorizationProperties.isEnabled()) {
            security = SecurityConfigUtils.configureSimpleSecurity(security, this.authorizationProperties);
        }
        String loginPage = this.dashboard(this.authorizationProperties.getLoginUrl());
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)security.and()).formLogin().loginPage(loginPage).loginProcessingUrl(this.dashboard(this.authorizationProperties.getLoginProcessingUrl()))).defaultSuccessUrl(this.dashboard("/"))).permitAll()).and()).logout().logoutUrl(this.dashboard(this.authorizationProperties.getLogoutUrl())).logoutSuccessUrl(this.dashboard(this.authorizationProperties.getLogoutSuccessUrl())).logoutSuccessHandler((LogoutSuccessHandler)new HttpStatusReturningLogoutSuccessHandler()).permitAll().and()).httpBasic().and()).exceptionHandling().defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(loginPage), (RequestMatcher)textHtmlMatcher).defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)basicAuthenticationEntryPoint, AnyRequestMatcher.INSTANCE);
        if (this.authorizationProperties.isEnabled()) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)security.anyRequest()).denyAll();
        } else {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)security.anyRequest()).authenticated();
        }
        SessionRepositoryFilter sessionRepositoryFilter = new SessionRepositoryFilter(this.sessionRepository());
        sessionRepositoryFilter.setHttpSessionStrategy((HttpSessionStrategy)new HeaderHttpSessionStrategy());
        http.addFilterBefore((Filter)sessionRepositoryFilter, ChannelProcessingFilter.class).csrf().disable();
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED);
        this.securityStateBean.setAuthenticationEnabled(true);
        this.securityStateBean.setAuthorizationEnabled(true);
    }

    private String dashboard(String path) {
        return this.authorizationProperties.getDashboardUrl() + path;
    }
}

