/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cluster.autoconfigure.leader;

import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.cluster.autoconfigure.leader.LeaderAutoConfiguration;
import org.springframework.cloud.cluster.leader.Candidate;
import org.springframework.cloud.cluster.leader.DefaultCandidate;
import org.springframework.cloud.cluster.leader.LeaderElectionProperties;
import org.springframework.cloud.cluster.leader.event.LeaderEventPublisher;
import org.springframework.cloud.cluster.zk.ZookeeperClusterProperties;
import org.springframework.cloud.cluster.zk.leader.LeaderInitiator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={LeaderInitiator.class})
@ConditionalOnProperty(value={"spring.cloud.cluster.zookeeper.leader.enabled", "spring.cloud.cluster.leader.enabled"}, matchIfMissing=true)
@ConditionalOnMissingBean(name={"zookeeperLeaderInitiator"})
@EnableConfigurationProperties(value={LeaderElectionProperties.class, ZookeeperClusterProperties.class})
@AutoConfigureAfter(value={LeaderAutoConfiguration.class})
public class ZookeeperLeaderAutoConfiguration {
    @Autowired
    private LeaderElectionProperties lep;
    @Autowired
    private ZookeeperClusterProperties zkp;
    @Autowired
    private LeaderEventPublisher publisher;

    @Bean
    public Candidate zookeeperLeaderCandidate() {
        return new DefaultCandidate(this.lep.getId(), this.lep.getRole());
    }

    @Bean(initMethod="start", destroyMethod="close")
    public CuratorFramework zookeeperLeaderCuratorClient() throws Exception {
        CuratorFramework client = CuratorFrameworkFactory.builder().defaultData(new byte[0]).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).connectString(this.zkp.getConnect()).build();
        return client;
    }

    @Bean
    public LeaderInitiator zookeeperLeaderInitiator() throws Exception {
        LeaderInitiator initiator = new LeaderInitiator(this.zookeeperLeaderCuratorClient(), this.zookeeperLeaderCandidate(), this.zkp.getNamespace());
        initiator.setLeaderEventPublisher(this.publisher);
        return initiator;
    }
}

