/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cluster.autoconfigure.leader;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.cluster.autoconfigure.leader.LeaderAutoConfiguration;
import org.springframework.cloud.cluster.hazelcast.HazelcastClusterProperties;
import org.springframework.cloud.cluster.hazelcast.leader.LeaderInitiator;
import org.springframework.cloud.cluster.leader.Candidate;
import org.springframework.cloud.cluster.leader.DefaultCandidate;
import org.springframework.cloud.cluster.leader.LeaderElectionProperties;
import org.springframework.cloud.cluster.leader.event.LeaderEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration
@ConditionalOnClass(value={LeaderInitiator.class})
@ConditionalOnProperty(value={"spring.cloud.cluster.leader.enabled", "spring.cloud.cluster.hazelcast.leader.enabled"}, matchIfMissing=true)
@ConditionalOnMissingBean(name={"hazelcastLeaderInitiator"})
@EnableConfigurationProperties(value={LeaderElectionProperties.class, HazelcastClusterProperties.class})
@AutoConfigureAfter(value={LeaderAutoConfiguration.class})
public class HazelcastLeaderAutoConfiguration {
    @Autowired
    private LeaderElectionProperties lep;
    @Autowired
    private HazelcastClusterProperties hp;
    @Autowired
    private LeaderEventPublisher publisher;

    @Bean
    public Candidate hazelcastLeaderCandidate() {
        return new DefaultCandidate(this.lep.getId(), this.lep.getRole());
    }

    @Bean
    public HazelcastInstance hazelcastInstance() {
        return Hazelcast.newHazelcastInstance((Config)this.hazelcastConfig());
    }

    @Bean
    public LeaderInitiator hazelcastLeaderInitiator() {
        LeaderInitiator initiator = new LeaderInitiator(this.hazelcastInstance(), this.hazelcastLeaderCandidate());
        initiator.setLeaderEventPublisher(this.publisher);
        return initiator;
    }

    @Bean
    public Config hazelcastConfig() {
        Resource location = this.hp.getConfigLocation();
        if (location != null && location.exists()) {
            try {
                return new XmlConfigBuilder(this.hp.getConfigLocation().getInputStream()).build();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to use config location " + location, e);
            }
        }
        return new Config();
    }
}

