/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cluster.autoconfigure.lock;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.cluster.lock.DistributedLockProperties;
import org.springframework.cloud.cluster.redis.RedisClusterProperties;
import org.springframework.cloud.cluster.redis.lock.RedisLockService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
@ConditionalOnClass(value={RedisLockService.class})
@ConditionalOnProperty(value={"spring.cloud.cluster.redis.lock.enabled", "spring.cloud.cluster.lock.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={DistributedLockProperties.class, RedisClusterProperties.class})
@ConditionalOnBean(value={RedisConnectionFactory.class})
public class RedisLockServiceAutoConfiguration {
    @Autowired
    private RedisConnectionFactory redisConnectionFactory;
    @Autowired
    private DistributedLockProperties distributedLockProperties;
    @Autowired
    private RedisClusterProperties redisClusterProperties;

    @Bean
    public RedisLockService redisLockService() {
        String role = this.distributedLockProperties.getRole();
        Long expire = this.redisClusterProperties.getLock().getExpireAfter();
        if (role != null && expire != null) {
            return new RedisLockService(this.redisConnectionFactory, role, expire.longValue());
        }
        if (role != null) {
            return new RedisLockService(this.redisConnectionFactory, role);
        }
        if (expire != null) {
            return new RedisLockService(this.redisConnectionFactory, expire.longValue());
        }
        return new RedisLockService(this.redisConnectionFactory);
    }
}

