/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.environment;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class VcapServiceCredentialsEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private int order = -2147483637;

    public int getOrder() {
        return this.order;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)environment);
        Map properties = resolver.getSubProperties("vcap.services.");
        if (properties == null || properties.isEmpty()) {
            return;
        }
        HashMap<String, Object> source = new HashMap<String, Object>();
        String serviceId = !resolver.getSubProperties("security.oauth2.resource.").isEmpty() ? resolver.getProperty("security.oauth2.resource.serviceId", "resource") : resolver.getProperty("security.oauth2.sso.serviceId", "sso");
        String authDomain = (String)properties.get(serviceId + ".credentials.auth_domain");
        if (authDomain != null) {
            source.put("security.oauth2.resource.userInfoUri", authDomain + "/userinfo");
            source.put("security.oauth2.resource.jwt.keyUri", authDomain + "/token_key");
            source.put("security.oauth2.client.accessTokenUri", authDomain + "/oauth/token");
            source.put("security.oauth2.client.userAuthorizationUri", authDomain + "/oauth/authorize");
        } else {
            this.addProperty(source, resolver, serviceId, "resource", "userInfoUri", new String[0]);
            this.addProperty(source, resolver, serviceId, "resource", "tokenInfoUri", new String[0]);
            this.addProperty(source, resolver, serviceId, "resource.jwt", "keyUri", new String[0]);
            this.addProperty(source, resolver, serviceId, "resource", "keyValue", new String[0]);
            this.addProperty(source, resolver, serviceId, "client", "accessTokenUri", "tokenUri");
            this.addProperty(source, resolver, serviceId, "client", "userAuthorizationUri", "authorizationUri");
        }
        this.addProperty(source, resolver, serviceId, "client", "clientId", new String[0]);
        this.addProperty(source, resolver, serviceId, "client", "clientSecret", new String[0]);
        this.addProperty(source, resolver, serviceId, "client", "scope", new String[0]);
        String resourceId = resolver.getProperty("vcap.services." + serviceId + ".credentials.id", "");
        if (StringUtils.hasText((String)resourceId)) {
            source.put("security.oauth2.resource.id", resourceId);
        }
        environment.getPropertySources().addLast((PropertySource)new MapPropertySource("cloudDefaultSecurityBindings", source));
    }

    private void addProperty(Map<String, Object> source, RelaxedPropertyResolver resolver, String serviceId, String stem, String key, String ... altKeys) {
        String value = this.resolve(resolver, serviceId, key);
        if (StringUtils.hasText((String)value)) {
            source.put("security.oauth2." + stem + "." + key, value);
            return;
        }
        for (String altKey : altKeys) {
            value = this.resolve(resolver, serviceId, altKey);
            if (!StringUtils.hasText((String)value)) continue;
            source.put("security.oauth2." + stem + "." + key, value);
            return;
        }
    }

    private String resolve(RelaxedPropertyResolver resolver, String serviceId, String key) {
        return resolver.getProperty(String.format("vcap.services.%s.credentials.%s", serviceId, key), "");
    }
}

