/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery.reactive;

import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CloudFoundryReactiveHeartbeatSender
implements ApplicationEventPublisherAware {
    private final ReactiveDiscoveryClient client;
    private ApplicationEventPublisher publisher;

    public CloudFoundryReactiveHeartbeatSender(ReactiveDiscoveryClient client) {
        this.client = client;
    }

    @Scheduled(fixedDelayString="${spring.cloud.cloudfoundry.discovery.heartbeatFrequency:5000}")
    public void poll() {
        if (this.publisher != null) {
            this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this.client, (Object)this.client.getServices()));
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }
}

