/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery;

import java.util.HashMap;
import java.util.List;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.cloudfoundry.operations.applications.InstanceDetail;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.cloudfoundry.CloudFoundryService;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryDiscoveryClient;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryDiscoveryProperties;

public class CloudFoundryAppServiceDiscoveryClient
extends CloudFoundryDiscoveryClient {
    private static final String INTERNAL_DOMAIN = "apps.internal";

    CloudFoundryAppServiceDiscoveryClient(CloudFoundryOperations cloudFoundryOperations, CloudFoundryService svc, CloudFoundryDiscoveryProperties cloudFoundryDiscoveryProperties) {
        super(cloudFoundryOperations, svc, cloudFoundryDiscoveryProperties);
    }

    @Override
    public String description() {
        return "CF App Service Discovery Client";
    }

    @Override
    public List<ServiceInstance> getInstances(String serviceId) {
        return (List)this.getCloudFoundryService().getApplicationInstances(serviceId).filter(tuple -> ((ApplicationDetail)tuple.getT1()).getUrls().stream().anyMatch(this::isInternalDomain)).map(tuple -> {
            ApplicationDetail applicationDetail = (ApplicationDetail)tuple.getT1();
            InstanceDetail instanceDetail = (InstanceDetail)tuple.getT2();
            String applicationId = applicationDetail.getId();
            String applicationIndex = instanceDetail.getIndex();
            String name = applicationDetail.getName();
            String url = applicationDetail.getUrls().stream().filter(this::isInternalDomain).findFirst().map(x -> instanceDetail.getIndex() + "." + x).get();
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("applicationId", applicationId);
            metadata.put("instanceId", applicationIndex);
            return new DefaultServiceInstance(name, url, 8080, false, metadata);
        }).collectList().block();
    }

    private boolean isInternalDomain(String url) {
        return url != null && url.endsWith(INTERNAL_DOMAIN);
    }
}

