/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery.reactive;

import org.cloudfoundry.operations.CloudFoundryOperations;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryHealthIndicatorEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.ReactiveCommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.composite.reactive.ReactiveCompositeDiscoveryClientAutoConfiguration;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryClientHealthIndicator;
import org.springframework.cloud.cloudfoundry.CloudFoundryService;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryDiscoveryProperties;
import org.springframework.cloud.cloudfoundry.discovery.ConditionalOnCloudFoundryDiscoveryEnabled;
import org.springframework.cloud.cloudfoundry.discovery.reactive.CloudFoundryAppServiceReactiveDiscoveryClient;
import org.springframework.cloud.cloudfoundry.discovery.reactive.CloudFoundryNativeReactiveDiscoveryClient;
import org.springframework.cloud.cloudfoundry.discovery.reactive.CloudFoundryReactiveHeartbeatSender;
import org.springframework.cloud.cloudfoundry.discovery.reactive.SimpleDnsBasedReactiveDiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={CloudFoundryOperations.class})
@ConditionalOnDiscoveryEnabled
@ConditionalOnReactiveDiscoveryEnabled
@ConditionalOnCloudFoundryDiscoveryEnabled
@EnableConfigurationProperties(value={CloudFoundryDiscoveryProperties.class})
@AutoConfigureAfter(value={ReactiveCompositeDiscoveryClientAutoConfiguration.class})
@AutoConfigureBefore(value={ReactiveCommonsClientAutoConfiguration.class})
public class CloudFoundryReactiveDiscoveryClientConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.cloud.cloudfoundry.discovery.use-dns"}, havingValue="true")
    public static class DnsBasedCloudFoundryReactiveDiscoveryClientConfig {

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnProperty(value={"spring.cloud.cloudfoundry.discovery.use-container-ip"}, havingValue="false", matchIfMissing=true)
        public static class CloudFoundryAppServiceReactiveDiscoveryClientConfig {
            @Bean
            @ConditionalOnMissingBean
            public CloudFoundryAppServiceReactiveDiscoveryClient appServiceReactiveDiscoveryClient(CloudFoundryOperations cf, CloudFoundryService svc, CloudFoundryDiscoveryProperties properties) {
                return new CloudFoundryAppServiceReactiveDiscoveryClient(cf, svc, properties);
            }

            @Bean
            @ConditionalOnClass(name={"org.springframework.boot.actuate.health.ReactiveHealthIndicator"})
            @ConditionalOnDiscoveryHealthIndicatorEnabled
            public ReactiveDiscoveryClientHealthIndicator cloudFoundryReactiveDiscoveryClientHealthIndicator(CloudFoundryAppServiceReactiveDiscoveryClient client, DiscoveryClientHealthIndicatorProperties properties) {
                return new ReactiveDiscoveryClientHealthIndicator((ReactiveDiscoveryClient)client, properties);
            }

            @Bean
            public CloudFoundryReactiveHeartbeatSender cloudFoundryHeartbeatSender(CloudFoundryAppServiceReactiveDiscoveryClient client) {
                return new CloudFoundryReactiveHeartbeatSender(client);
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnProperty(value={"spring.cloud.cloudfoundry.discovery.use-container-ip"}, havingValue="true")
        public static class CloudFoundrySimpleDnsBasedReactiveDiscoveryClientConfig {
            @Bean
            @ConditionalOnMissingBean
            public SimpleDnsBasedReactiveDiscoveryClient dnsBasedReactiveDiscoveryClient(ObjectProvider<SimpleDnsBasedReactiveDiscoveryClient.ServiceIdToHostnameConverter> provider, CloudFoundryDiscoveryProperties properties) {
                SimpleDnsBasedReactiveDiscoveryClient.ServiceIdToHostnameConverter converter = (SimpleDnsBasedReactiveDiscoveryClient.ServiceIdToHostnameConverter)provider.getIfAvailable();
                return converter == null ? new SimpleDnsBasedReactiveDiscoveryClient(properties) : new SimpleDnsBasedReactiveDiscoveryClient(converter);
            }

            @Bean
            @ConditionalOnClass(name={"org.springframework.boot.actuate.health.ReactiveHealthIndicator"})
            @ConditionalOnDiscoveryHealthIndicatorEnabled
            public ReactiveDiscoveryClientHealthIndicator cloudFoundryReactiveDiscoveryClientHealthIndicator(SimpleDnsBasedReactiveDiscoveryClient client, DiscoveryClientHealthIndicatorProperties properties) {
                return new ReactiveDiscoveryClientHealthIndicator((ReactiveDiscoveryClient)client, properties);
            }

            @Bean
            public CloudFoundryReactiveHeartbeatSender cloudFoundryHeartbeatSender(SimpleDnsBasedReactiveDiscoveryClient client) {
                return new CloudFoundryReactiveHeartbeatSender(client);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.cloud.cloudfoundry.discovery.use-dns"}, havingValue="false", matchIfMissing=true)
    public static class CloudFoundryNativeReactiveDiscoveryClientConfig {
        @Bean
        @ConditionalOnMissingBean
        public CloudFoundryNativeReactiveDiscoveryClient nativeCloudFoundryDiscoveryClient(CloudFoundryOperations cf, CloudFoundryService svc, CloudFoundryDiscoveryProperties cloudFoundryDiscoveryProperties) {
            return new CloudFoundryNativeReactiveDiscoveryClient(cf, svc, cloudFoundryDiscoveryProperties);
        }

        @Bean
        @ConditionalOnClass(name={"org.springframework.boot.actuate.health.ReactiveHealthIndicator"})
        @ConditionalOnDiscoveryHealthIndicatorEnabled
        public ReactiveDiscoveryClientHealthIndicator cloudFoundryReactiveDiscoveryClientHealthIndicator(CloudFoundryNativeReactiveDiscoveryClient client, DiscoveryClientHealthIndicatorProperties properties) {
            return new ReactiveDiscoveryClientHealthIndicator((ReactiveDiscoveryClient)client, properties);
        }

        @Bean
        public CloudFoundryReactiveHeartbeatSender cloudFoundryHeartbeatSender(CloudFoundryNativeReactiveDiscoveryClient client) {
            return new CloudFoundryReactiveHeartbeatSender(client);
        }
    }
}

