/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery;

import org.cloudfoundry.operations.CloudFoundryOperations;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.cloudfoundry.CloudFoundryService;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryDiscoveryClient;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryDiscoveryProperties;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryHeartbeatSender;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={CloudFoundryOperations.class})
@ConditionalOnProperty(value={"spring.cloud.cloudfoundry.discovery.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={CloudFoundryDiscoveryProperties.class})
public class CloudFoundryDiscoveryClientConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CloudFoundryDiscoveryClient.class})
    public CloudFoundryDiscoveryClient cloudFoundryDiscoveryClient(CloudFoundryOperations cf, CloudFoundryService svc, CloudFoundryDiscoveryProperties cloudFoundryDiscoveryProperties) {
        return new CloudFoundryDiscoveryClient(cf, svc, cloudFoundryDiscoveryProperties);
    }

    @Bean
    public CloudFoundryHeartbeatSender cloudFoundryHeartbeatSender(CloudFoundryDiscoveryClient client) {
        return new CloudFoundryHeartbeatSender(client);
    }
}

