/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery;

import java.net.MalformedURLException;
import java.net.URI;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryDiscoveryClient;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryDiscoveryProperties;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryHeartbeatSender;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={CloudFoundryClient.class})
@ConditionalOnProperty(value={"spring.cloud.cloudfoundry.discovery.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={CloudFoundryDiscoveryProperties.class})
public class CloudFoundryDiscoveryClientConfiguration {
    @Autowired
    private CloudFoundryDiscoveryProperties discovery;

    @Bean
    @ConditionalOnMissingBean(value={CloudCredentials.class})
    public CloudCredentials cloudCredentials() {
        return new CloudCredentials(this.discovery.getUsername(), this.discovery.getPassword());
    }

    @Bean
    @ConditionalOnMissingBean(value={CloudFoundryClient.class})
    public CloudFoundryClient cloudFoundryClient(CloudCredentials cc) throws MalformedURLException {
        CloudFoundryClient cloudFoundryClient = StringUtils.hasText((String)this.discovery.getOrg()) && StringUtils.hasText((String)this.discovery.getSpace()) ? new CloudFoundryClient(cc, URI.create(this.discovery.getUrl()).toURL(), this.discovery.getOrg(), this.discovery.getSpace()) : new CloudFoundryClient(cc, URI.create(this.discovery.getUrl()).toURL());
        cloudFoundryClient.login();
        return cloudFoundryClient;
    }

    @Bean
    @ConditionalOnMissingBean(value={CloudFoundryDiscoveryClient.class})
    public CloudFoundryDiscoveryClient cloudFoundryDiscoveryClient(CloudFoundryClient cloudFoundryClient, Environment environment) {
        return new CloudFoundryDiscoveryClient(cloudFoundryClient, environment);
    }

    @Bean
    public CloudFoundryHeartbeatSender cloudFoundryHeartbeatSender(CloudFoundryDiscoveryClient client) {
        return new CloudFoundryHeartbeatSender(client);
    }
}

