/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cli.command.url;

import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import joptsimple.OptionSet;
import org.springframework.boot.cli.command.OptionParsingCommand;
import org.springframework.boot.cli.command.options.OptionHandler;
import org.springframework.boot.cli.command.status.ExitStatus;
import org.springframework.cloud.cli.command.url.BaseEncodeOptionHandler;
import org.springframework.util.StringUtils;

public class UrlEncodeCommand
extends OptionParsingCommand {
    public UrlEncodeCommand() {
        super("urlEncode", "URL encodes the subsequent string", (OptionHandler)new UrlEncodeOptionHandler());
    }

    public String getUsageHelp() {
        return "[options] <text>";
    }

    private static class UrlEncodeOptionHandler
    extends BaseEncodeOptionHandler {
        private UrlEncodeOptionHandler() {
        }

        protected synchronized ExitStatus run(OptionSet options) throws Exception {
            String charset = "UTF-8";
            if (options.has(this.charsetOption)) {
                charset = (String)options.valueOf(this.charsetOption);
            }
            String text = StringUtils.collectionToDelimitedString((Collection)options.nonOptionArguments(), (String)" ");
            try {
                Charset.forName(charset);
                String outText = URLEncoder.encode(text, charset);
                System.out.println(outText);
                return ExitStatus.OK;
            }
            catch (UnsupportedCharsetException e) {
                System.out.println("Unsupported Character Set");
                return ExitStatus.ERROR;
            }
        }
    }
}

