/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cli.compiler;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;

public class EurekaServerCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation((ClassNode)classNode, (String[])new String[]{"EnableEurekaServer"});
    }

    public void applyDependencies(DependencyCustomizer dependencies) {
        dependencies.ifAnyMissingClasses(new String[]{"org.springframework.cloud.netflix.eureka.server.EnableEurekaServer"}).add(new String[]{"spring-cloud-starter-netflix-eureka-server"});
    }

    public void applyImports(ImportCustomizer imports) throws CompilationFailedException {
        imports.addImports(new String[]{"org.springframework.cloud.netflix.eureka.server.EnableEurekaServer", "org.springframework.cloud.client.discovery.EnableDiscoveryClient", "org.springframework.cloud.netflix.eureka.server.EurekaServerConfigBean", "org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean", "org.springframework.cloud.netflix.eureka.EurekaClientConfigBean", "com.netflix.discovery.DiscoveryClient", "com.netflix.appinfo.InstanceInfo"});
    }
}

