/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cli.compiler;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;

public class RibbonClientCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation((ClassNode)classNode, (String[])new String[]{"RibbonClient"});
    }

    public void applyDependencies(DependencyCustomizer dependencies) {
        dependencies.ifAnyMissingClasses(new String[]{"org.springframework.cloud.netflix.ribbon.RibbonClient"}).add(new String[]{"spring-cloud-starter-ribbon", "spring-web"});
    }

    public void applyImports(ImportCustomizer imports) throws CompilationFailedException {
        imports.addImports(new String[]{"org.springframework.cloud.netflix.ribbon.RibbonClient", "org.springframework.cloud.client.loadbalancer.LoadBalancerClient", "org.springframework.web.client.RestTemplate", "com.netflix.client.config.DefaultClientConfigImpl", "com.netflix.client.config.IClientConfig", "com.netflix.loadbalancer.DynamicServerListLoadBalancer", "com.netflix.loadbalancer.ILoadBalancer", "com.netflix.loadbalancer.Server", "com.netflix.loadbalancer.ServerList", "com.netflix.loadbalancer.ServerListFilter", "com.netflix.niws.client.http.RestClient"});
    }
}

