/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cli.command.encrypt;

import org.springframework.boot.cli.util.Log;
import org.springframework.cloud.cli.command.encrypt.KeyFormatException;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;

public class EncryptorFactory {
    private static final String SALT = "deadbeef";
    private final boolean verbose;

    public EncryptorFactory() {
        this(false);
    }

    public EncryptorFactory(boolean verbose) {
        this.verbose = verbose;
    }

    public TextEncryptor create(String data) {
        RsaSecretEncryptor encryptor;
        block11: {
            block10: {
                encryptor = null;
                try {
                    encryptor = new RsaSecretEncryptor(data);
                }
                catch (IllegalArgumentException e) {
                    if (!this.verbose) break block10;
                    Log.info((String)("Could not create RSA Encryptor (" + e.getMessage() + ")"));
                }
            }
            if (encryptor == null) {
                if (this.verbose) {
                    Log.info((String)"Trying public key");
                }
                try {
                    encryptor = new RsaSecretEncryptor(data);
                }
                catch (IllegalArgumentException e) {
                    if (!this.verbose) break block11;
                    Log.info((String)("Could not create public key RSA Encryptor (" + e.getMessage() + ")"));
                }
            }
        }
        if (encryptor == null) {
            if (this.verbose) {
                Log.info((String)"Trying symmetric key");
            }
            encryptor = Encryptors.text((CharSequence)data, (CharSequence)SALT);
        }
        if (encryptor == null) {
            if (this.verbose) {
                Log.error((String)"Could not create any Encryptor");
            }
            throw new KeyFormatException();
        }
        return encryptor;
    }
}

