/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.springretry;

import java.io.Serializable;
import org.springframework.classify.Classifier;
import org.springframework.cloud.circuitbreaker.springretry.SpringRetryConfig;
import org.springframework.cloud.client.circuitbreaker.ConfigBuilder;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.policy.CircuitBreakerRetryPolicy;

public class SpringRetryConfigBuilder
implements ConfigBuilder<SpringRetryConfig> {
    private final String id;
    private BackOffPolicy backOffPolicy = new NoBackOffPolicy();
    private RetryPolicy retryPolicy = new CircuitBreakerRetryPolicy();
    private boolean forceRefreshState = false;
    private Classifier<Throwable, Boolean> stateClassifier = (Classifier & Serializable)classifiable -> false;

    public SpringRetryConfigBuilder(String id) {
        this.id = id;
    }

    public SpringRetryConfigBuilder backOffPolicy(BackOffPolicy backOffPolicy) {
        this.backOffPolicy = backOffPolicy;
        return this;
    }

    public SpringRetryConfigBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = new CircuitBreakerRetryPolicy(retryPolicy);
        return this;
    }

    public SpringRetryConfigBuilder retryPolicy(CircuitBreakerRetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public SpringRetryConfigBuilder forceRefreshState(boolean refresh) {
        this.forceRefreshState = refresh;
        return this;
    }

    public SpringRetryConfigBuilder stateClassifier(Classifier<Throwable, Boolean> classifier) {
        this.stateClassifier = classifier;
        return this;
    }

    public SpringRetryConfig build() {
        return new SpringRetryConfig().setBackOffPolicy(this.backOffPolicy).setId(this.id).setRetryPolicy(this.retryPolicy).setForceRefreshState(this.forceRefreshState).setStateClassifier(this.stateClassifier);
    }
}

