/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.springretry;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.circuitbreaker.springretry.SpringRetryCircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.retry.support.RetryTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RetryTemplate.class})
public class SpringRetryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CircuitBreakerFactory.class})
    public CircuitBreakerFactory resilience4jCircuitBreakerFactory() {
        return new SpringRetryCircuitBreakerFactory();
    }

    @Configuration(proxyBeanMethods=false)
    public static class SpringRetryCustomizerConfiguration {
        @Autowired(required=false)
        private List<Customizer<SpringRetryCircuitBreakerFactory>> customizers = new ArrayList<Customizer<SpringRetryCircuitBreakerFactory>>();
        @Autowired(required=false)
        private SpringRetryCircuitBreakerFactory factory;

        @PostConstruct
        public void init() {
            this.customizers.forEach(customizer -> customizer.customize((Object)this.factory));
        }
    }
}

