/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.reactor.circuitbreaker.operator.CircuitBreakerOperator;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JConfigBuilder;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveResilience4JCircuitBreaker
implements ReactiveCircuitBreaker {
    private String id;
    private Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration config;
    private CircuitBreakerRegistry registry;
    private Optional<Customizer<CircuitBreaker>> circuitBreakerCustomizer;

    public ReactiveResilience4JCircuitBreaker(String id, Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration config, CircuitBreakerRegistry circuitBreakerRegistry, Optional<Customizer<CircuitBreaker>> circuitBreakerCustomizer) {
        this.id = id;
        this.config = config;
        this.registry = circuitBreakerRegistry;
        this.circuitBreakerCustomizer = circuitBreakerCustomizer;
    }

    public <T> Mono<T> run(Mono<T> toRun, Function<Throwable, Mono<T>> fallback) {
        CircuitBreaker defaultCircuitBreaker = this.registry.circuitBreaker(this.id, this.config.getCircuitBreakerConfig());
        this.circuitBreakerCustomizer.ifPresent(customizer -> customizer.customize((Object)defaultCircuitBreaker));
        Mono toReturn = toRun.transform((Function)CircuitBreakerOperator.of((CircuitBreaker)defaultCircuitBreaker)).timeout(this.config.getTimeLimiterConfig().getTimeoutDuration()).doOnError(TimeoutException.class, t -> defaultCircuitBreaker.onError(this.config.getTimeLimiterConfig().getTimeoutDuration().toMillis(), TimeUnit.MILLISECONDS, (Throwable)t));
        if (fallback != null) {
            toReturn = toReturn.onErrorResume(fallback);
        }
        return toReturn;
    }

    public <T> Flux<T> run(Flux<T> toRun, Function<Throwable, Flux<T>> fallback) {
        CircuitBreaker defaultCircuitBreaker = this.registry.circuitBreaker(this.id, this.config.getCircuitBreakerConfig());
        this.circuitBreakerCustomizer.ifPresent(customizer -> customizer.customize((Object)defaultCircuitBreaker));
        Flux toReturn = toRun.transform((Function)CircuitBreakerOperator.of((CircuitBreaker)defaultCircuitBreaker)).timeout(this.config.getTimeLimiterConfig().getTimeoutDuration()).doOnError(TimeoutException.class, t -> defaultCircuitBreaker.onError(this.config.getTimeLimiterConfig().getTimeoutDuration().toMillis(), TimeUnit.MILLISECONDS, (Throwable)t));
        if (fallback != null) {
            toReturn = toReturn.onErrorResume(fallback);
        }
        return toReturn;
    }
}

