/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.retry;

import java.time.Duration;
import org.springframework.cloud.circuitbreaker.retry.CircuitBreakerRetryPolicy;
import org.springframework.cloud.circuitbreaker.retry.FrameworkRetryConfig;
import org.springframework.cloud.client.circuitbreaker.ConfigBuilder;
import org.springframework.core.retry.RetryPolicy;

public class FrameworkRetryConfigBuilder
implements ConfigBuilder<FrameworkRetryConfig> {
    private final String id;
    private RetryPolicy retryPolicy = RetryPolicy.withDefaults();
    private Duration openTimeout = Duration.ofSeconds(20L);
    private Duration resetTimeout = Duration.ofSeconds(5L);

    public FrameworkRetryConfigBuilder(String id) {
        this.id = id;
    }

    public FrameworkRetryConfigBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public FrameworkRetryConfigBuilder openTimeout(Duration openTimeout) {
        this.openTimeout = openTimeout;
        return this;
    }

    public FrameworkRetryConfigBuilder resetTimeout(Duration resetTimeout) {
        this.resetTimeout = resetTimeout;
        return this;
    }

    public FrameworkRetryConfig build() {
        CircuitBreakerRetryPolicy circuitBreakerPolicy = new CircuitBreakerRetryPolicy(this.retryPolicy, this.openTimeout, this.resetTimeout);
        return new FrameworkRetryConfig().setId(this.id).setRetryPolicy(this.retryPolicy).setCircuitBreakerRetryPolicy(circuitBreakerPolicy);
    }
}

