/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.retry;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.core.retry.RetryPolicy;

public class CircuitBreakerRetryPolicy {
    private final RetryPolicy retryPolicy;
    private final AtomicReference<State> state = new AtomicReference<State>(State.CLOSED);
    private final AtomicLong openedAt = new AtomicLong(0L);
    private final AtomicLong lastFailureTime = new AtomicLong(0L);
    private final AtomicReference<Throwable> lastException = new AtomicReference();
    private final Duration openTimeout;
    private final Duration resetTimeout;

    public CircuitBreakerRetryPolicy(RetryPolicy retryPolicy) {
        this(retryPolicy, Duration.ofSeconds(20L), Duration.ofSeconds(5L));
    }

    public CircuitBreakerRetryPolicy(RetryPolicy retryPolicy, Duration openTimeout, Duration resetTimeout) {
        this.retryPolicy = retryPolicy;
        this.openTimeout = openTimeout;
        this.resetTimeout = resetTimeout;
    }

    public boolean canRetry() {
        State currentState = this.state.get();
        long now = System.currentTimeMillis();
        long lastFailure = this.lastFailureTime.get();
        if (lastFailure > 0L && now - lastFailure >= this.resetTimeout.toMillis()) {
            if (currentState == State.OPEN && this.state.compareAndSet(State.OPEN, State.CLOSED)) {
                this.lastException.set(null);
            }
            currentState = this.state.get();
        }
        if (currentState == State.OPEN) {
            long opened = this.openedAt.get();
            return now - opened >= this.openTimeout.toMillis() && this.state.compareAndSet(State.OPEN, State.HALF_OPEN);
        }
        return true;
    }

    public void recordSuccess() {
        State currentState = this.state.get();
        if (currentState == State.HALF_OPEN) {
            if (this.state.compareAndSet(State.HALF_OPEN, State.CLOSED)) {
                this.lastException.set(null);
                this.lastFailureTime.set(0L);
            }
        } else if (currentState == State.CLOSED) {
            this.lastException.set(null);
            this.lastFailureTime.set(0L);
        }
    }

    public void recordFailure(Throwable exception) {
        this.lastException.set(exception);
        this.lastFailureTime.set(System.currentTimeMillis());
        State currentState = this.state.get();
        if (currentState == State.HALF_OPEN) {
            if (this.state.compareAndSet(State.HALF_OPEN, State.OPEN)) {
                this.openedAt.set(System.currentTimeMillis());
            }
        } else if (currentState == State.CLOSED && this.state.compareAndSet(State.CLOSED, State.OPEN)) {
            this.openedAt.set(System.currentTimeMillis());
        }
    }

    public boolean isOpen() {
        return this.state.get() == State.OPEN;
    }

    public State getState() {
        return this.state.get();
    }

    public Throwable getLastException() {
        return this.lastException.get();
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public Duration getOpenTimeout() {
        return this.openTimeout;
    }

    public Duration getResetTimeout() {
        return this.resetTimeout;
    }

    public void reset() {
        this.state.set(State.CLOSED);
        this.openedAt.set(0L);
        this.lastFailureTime.set(0L);
        this.lastException.set(null);
    }

    public static enum State {
        CLOSED,
        OPEN,
        HALF_OPEN;

    }
}

