/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.endpoint;

import org.springframework.cloud.bus.event.Destination;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class AbstractBusEndpoint {
    private ApplicationEventPublisher publisher;
    private String appId;
    private final Destination.Factory destinationFactory;

    public AbstractBusEndpoint(ApplicationEventPublisher publisher, String appId, Destination.Factory destinationFactory) {
        this.publisher = publisher;
        this.appId = appId;
        this.destinationFactory = destinationFactory;
    }

    protected String getInstanceId() {
        return this.appId;
    }

    protected Destination.Factory getDestinationFactory() {
        return this.destinationFactory;
    }

    protected Destination getDestination(String original) {
        return this.destinationFactory.getDestination(original);
    }

    protected void publish(ApplicationEvent event) {
        this.publisher.publishEvent(event);
    }
}

