/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.event;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.UUID;
import org.springframework.cloud.bus.event.Destination;
import org.springframework.cloud.bus.event.PathDestinationFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonIgnoreProperties(value={"source"})
public abstract class RemoteApplicationEvent
extends ApplicationEvent {
    private static final Object TRANSIENT_SOURCE = new Object();
    private static final String TRANSIENT_ORIGIN = "____transient_origin_service___";
    private static final String TRANSIENT_DESTINATION = "____transient_destination___";
    protected static final PathDestinationFactory DEFAULT_DESTINATION_FACTORY = new PathDestinationFactory();
    private String originService;
    private String destinationService;
    private String id;

    protected RemoteApplicationEvent() {
        this(TRANSIENT_SOURCE, TRANSIENT_ORIGIN, DEFAULT_DESTINATION_FACTORY.getDestination(TRANSIENT_DESTINATION));
    }

    @Deprecated
    protected RemoteApplicationEvent(Object source, String originService, String destinationService) {
        this(source, originService, DEFAULT_DESTINATION_FACTORY.getDestination(destinationService));
    }

    protected RemoteApplicationEvent(Object source, String originService, Destination destination) {
        super(source);
        if (!originService.equals(TRANSIENT_ORIGIN)) {
            Assert.notNull((Object)originService, (String)"originService may not be null");
            this.originService = originService;
        } else {
            this.originService = null;
        }
        Assert.notNull((Object)destination, (String)"destination may not be null");
        this.destinationService = destination.getDestinationAsString();
        Assert.hasText((String)this.destinationService, (String)"destinationService may not be empty");
        this.id = UUID.randomUUID().toString();
    }

    @Deprecated
    protected RemoteApplicationEvent(Object source, String originService) {
        this(source, originService, DEFAULT_DESTINATION_FACTORY.getDestination(null));
    }

    public String getOriginService() {
        return this.originService;
    }

    public String getDestinationService() {
        return this.destinationService;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destinationService == null ? 0 : this.destinationService.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.originService == null ? 0 : this.originService.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RemoteApplicationEvent other = (RemoteApplicationEvent)((Object)obj);
        if (this.destinationService == null ? other.destinationService != null : !this.destinationService.equals(other.destinationService)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.originService == null ? other.originService != null : !this.originService.equals(other.originService));
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.id).append("originService", (Object)this.originService).append("destinationService", (Object)this.destinationService).toString();
    }
}

