/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.cloud.bus.ConditionalOnBusEnabled;
import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.cloud.bus.endpoint.ShutdownBusEndpoint;
import org.springframework.cloud.bus.event.Destination;
import org.springframework.cloud.bus.event.ShutdownListener;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBusEnabled
public class BusShutdownAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"spring.cloud.bus.shutdown.enabled"}, matchIfMissing=true)
    @ConditionalOnMissingBean
    public ShutdownListener shutdownListener(ServiceMatcher serviceMatcher) {
        return new ShutdownListener(serviceMatcher);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.boot.actuate.endpoint.annotation.Endpoint"})
    protected static class BusShutdownEndpointConfiguration {
        protected BusShutdownEndpointConfiguration() {
        }

        @Bean
        public ShutdownBusEndpoint shutdownBusEndpoint(ApplicationEventPublisher publisher, BusProperties bus, Destination.Factory destinationFactory) {
            return new ShutdownBusEndpoint(publisher, bus.getId(), destinationFactory);
        }
    }
}

