/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus;

import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.trace.http.HttpTraceRepository;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bus.BusPathMatcher;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.cloud.bus.ConditionalOnBusEnabled;
import org.springframework.cloud.bus.DefaultBusPathMatcher;
import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.cloud.bus.SpringCloudBusClient;
import org.springframework.cloud.bus.endpoint.EnvironmentBusEndpoint;
import org.springframework.cloud.bus.event.AckRemoteApplicationEvent;
import org.springframework.cloud.bus.event.EnvironmentChangeListener;
import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.cloud.bus.event.SentApplicationEvent;
import org.springframework.cloud.bus.event.TraceListener;
import org.springframework.cloud.context.environment.EnvironmentManager;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

@Configuration
@ConditionalOnBusEnabled
@EnableBinding(value={SpringCloudBusClient.class})
@EnableConfigurationProperties(value={BusProperties.class})
public class BusAutoConfiguration
implements ApplicationEventPublisherAware {
    public static final String BUS_PATH_MATCHER_NAME = "busPathMatcher";
    @Autowired
    @Output(value="springCloudBusOutput")
    private MessageChannel cloudBusOutboundChannel;
    @Autowired
    private ServiceMatcher serviceMatcher;
    @Autowired
    private BindingServiceProperties bindings;
    @Autowired
    private BusProperties bus;
    private ApplicationEventPublisher applicationEventPublisher;

    @PostConstruct
    public void init() {
        BindingProperties output;
        BindingProperties outputBinding;
        BindingProperties input;
        BindingProperties inputBinding = (BindingProperties)this.bindings.getBindings().get("springCloudBusInput");
        if (inputBinding == null) {
            this.bindings.getBindings().put("springCloudBusInput", new BindingProperties());
        }
        if ((input = (BindingProperties)this.bindings.getBindings().get("springCloudBusInput")).getDestination() == null) {
            input.setDestination(this.bus.getDestination());
        }
        if ((outputBinding = (BindingProperties)this.bindings.getBindings().get("springCloudBusOutput")) == null) {
            this.bindings.getBindings().put("springCloudBusOutput", new BindingProperties());
        }
        if ((output = (BindingProperties)this.bindings.getBindings().get("springCloudBusOutput")).getDestination() == null) {
            output.setDestination(this.bus.getDestination());
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @EventListener(classes={RemoteApplicationEvent.class})
    public void acceptLocal(RemoteApplicationEvent event) {
        if (this.serviceMatcher.isFromSelf(event) && !(event instanceof AckRemoteApplicationEvent)) {
            this.cloudBusOutboundChannel.send(MessageBuilder.withPayload((Object)((Object)event)).build());
        }
    }

    @StreamListener(value="springCloudBusInput")
    public void acceptRemote(RemoteApplicationEvent event) {
        if (event instanceof AckRemoteApplicationEvent) {
            if (this.bus.getTrace().isEnabled() && !this.serviceMatcher.isFromSelf(event) && this.applicationEventPublisher != null) {
                this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
            }
            return;
        }
        if (this.serviceMatcher.isForSelf(event) && this.applicationEventPublisher != null) {
            if (!this.serviceMatcher.isFromSelf(event)) {
                this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
            }
            if (this.bus.getAck().isEnabled()) {
                AckRemoteApplicationEvent ack = new AckRemoteApplicationEvent(this, this.serviceMatcher.getServiceId(), this.bus.getAck().getDestinationService(), event.getDestinationService(), event.getId(), ((Object)((Object)event)).getClass());
                this.cloudBusOutboundChannel.send(MessageBuilder.withPayload((Object)((Object)ack)).build());
                this.applicationEventPublisher.publishEvent((ApplicationEvent)ack);
            }
        }
        if (this.bus.getTrace().isEnabled() && this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new SentApplicationEvent(this, event.getOriginService(), event.getDestinationService(), event.getId(), ((Object)((Object)event)).getClass()));
        }
    }

    @Configuration
    @ConditionalOnClass(value={EnvironmentManager.class})
    @ConditionalOnBean(value={EnvironmentManager.class})
    protected static class BusEnvironmentConfiguration {
        protected BusEnvironmentConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.bus.env.enabled"}, matchIfMissing=true)
        public EnvironmentChangeListener environmentChangeListener() {
            return new EnvironmentChangeListener();
        }

        @Configuration
        @ConditionalOnClass(value={Endpoint.class})
        protected static class EnvironmentBusEndpointConfiguration {
            protected EnvironmentBusEndpointConfiguration() {
            }

            @Bean
            @ConditionalOnEnabledEndpoint
            public EnvironmentBusEndpoint environmentBusEndpoint(ApplicationContext context, BusProperties bus) {
                return new EnvironmentBusEndpoint((ApplicationEventPublisher)context, bus.getId());
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    @ConditionalOnBean(value={HttpTraceRepository.class})
    @ConditionalOnProperty(value={"spring.cloud.bus.trace.enabled"}, matchIfMissing=false)
    protected static class BusAckTraceConfiguration {
        protected BusAckTraceConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public TraceListener ackTraceListener(HttpTraceRepository repository) {
            return new TraceListener(repository);
        }
    }

    @Configuration
    protected static class MatcherConfiguration {
        protected MatcherConfiguration() {
        }

        @BusPathMatcher
        @ConditionalOnMissingBean(name={"busPathMatcher"})
        @Bean(name={"busPathMatcher"})
        public PathMatcher busPathMatcher() {
            return new DefaultBusPathMatcher((PathMatcher)new AntPathMatcher(":"));
        }

        @Bean
        public ServiceMatcher serviceMatcher(@BusPathMatcher PathMatcher pathMatcher, BusProperties properties) {
            ServiceMatcher serviceMatcher = new ServiceMatcher(pathMatcher, properties.getId());
            return serviceMatcher;
        }
    }
}

