/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.rsocket;

import java.util.ArrayList;
import org.springframework.cloud.bus.event.Destination;
import org.springframework.cloud.bus.rsocket.BusRSocketProperties;
import org.springframework.util.StringUtils;

public class RoutingClientDestinationFactory
implements Destination.Factory {
    private final BusRSocketProperties properties;

    public RoutingClientDestinationFactory(BusRSocketProperties properties) {
        this.properties = properties;
    }

    public Destination getDestination(String originalDestination) {
        ArrayList entries = new ArrayList();
        this.properties.getDefaultTags().forEach((key, s) -> {
            String keyStr = key.getWellKnownKey() != null ? key.getWellKnownKey().name() : key.getKey();
            entries.add(keyStr + "=" + s);
        });
        String defaultTags = StringUtils.collectionToDelimitedString(entries, (String)":");
        return () -> {
            String destination;
            String string = destination = StringUtils.isEmpty((Object)originalDestination) ? defaultTags : defaultTags + ":" + originalDestination;
            if (StringUtils.isEmpty((Object)destination)) {
                throw new IllegalArgumentException("destination may not be empty");
            }
            return destination;
        };
    }
}

