/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.util.Map;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.cloud.bindings.boot.Guards;
import org.springframework.cloud.bindings.boot.MapMapper;
import org.springframework.core.env.Environment;

final class RabbitMqBindingsPropertiesProcessor
implements BindingsPropertiesProcessor {
    public static final String TYPE = "rabbitmq";

    RabbitMqBindingsPropertiesProcessor() {
    }

    @Override
    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!Guards.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            MapMapper map = new MapMapper(binding.getSecret(), properties);
            map.from("addresses").to("spring.rabbitmq.addresses");
            map.from("host").to("spring.rabbitmq.host");
            map.from("password").to("spring.rabbitmq.password");
            map.from("port").to("spring.rabbitmq.port");
            map.from("username").to("spring.rabbitmq.username");
            map.from("virtual-host").to("spring.rabbitmq.virtual-host");
        });
    }
}

