/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.nio.file.Path;
import java.util.Map;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.cloud.bindings.boot.Guards;
import org.springframework.cloud.bindings.boot.MapMapper;
import org.springframework.cloud.bindings.boot.pem.PemSslStoreHelper;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

final class ConfigServerBindingsPropertiesProcessor
implements BindingsPropertiesProcessor {
    public static final String TYPE = "config";

    ConfigServerBindingsPropertiesProcessor() {
    }

    @Override
    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!Guards.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            Map<String, String> secret = binding.getSecret();
            MapMapper map = new MapMapper(secret, properties);
            map.from("uri").to("spring.cloud.config.uri");
            map.from("client-id").to("spring.cloud.config.client.oauth2.clientId");
            map.from("client-secret").to("spring.cloud.config.client.oauth2.clientSecret");
            map.from("access-token-uri").to("spring.cloud.config.client.oauth2.accessTokenUri");
            String clientKey = secret.get("tls.key");
            String clientCert = secret.get("tls.crt");
            if (StringUtils.hasText((String)clientCert) != StringUtils.hasText((String)clientKey)) {
                throw new IllegalArgumentException("binding secret error: tls.key and tls.crt must both be set if either is set");
            }
            if (clientKey != null && !clientKey.isEmpty()) {
                String generatedPassword = PemSslStoreHelper.generatePassword();
                Path keyFilePath = PemSslStoreHelper.createKeyStoreFile("config-keystore", generatedPassword, clientCert, clientKey, TYPE);
                properties.put("spring.cloud.config.tls.enabled", true);
                properties.put("spring.cloud.config.tls.key-alias", TYPE);
                properties.put("spring.cloud.config.tls.key-store", "file:" + keyFilePath);
                properties.put("spring.cloud.config.tls.key-store-type", "PKCS12");
                properties.put("spring.cloud.config.tls.key-store-password", generatedPassword);
                properties.put("spring.cloud.config.tls.key-password", "");
                String caCert = secret.get("ca.crt");
                if (caCert != null && !caCert.isEmpty()) {
                    Path trustFilePath = PemSslStoreHelper.createKeyStoreFile("config-truststore", generatedPassword, caCert, null, "ca");
                    properties.put("spring.cloud.config.tls.trust-store", "file:" + trustFilePath);
                    properties.put("spring.cloud.config.tls.trust-store-type", "PKCS12");
                    properties.put("spring.cloud.config.tls.trust-store-password", generatedPassword);
                }
            }
        });
    }
}

